/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.net.URL;
import jnr.posix.JavaSecuredFile;
import org.jruby.Ruby;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.Library;

public class ClassExtensionLibrary
implements Library {
    private final Class theClass;
    private final String name;

    static ClassExtensionLibrary tryFind(Ruby runtime, String searchName) {
        int firstElement;
        String[] elts = searchName.split("/");
        boolean isAbsolute = new JavaSecuredFile(searchName).isAbsolute();
        String simpleName = ClassExtensionLibrary.buildSimpleName(elts[elts.length - 1]);
        int n = firstElement = isAbsolute ? elts.length - 1 : 0;
        while (firstElement >= 0) {
            String className = ClassExtensionLibrary.buildClassName(elts, firstElement, elts.length - 1, simpleName);
            ClassExtensionLibrary library2 = ClassExtensionLibrary.tryServiceLoad(runtime, className);
            if (library2 != null) {
                return library2;
            }
            --firstElement;
        }
        return null;
    }

    private static String buildSimpleName(String element) {
        String[] last2;
        StringBuilder nameBuilder = new StringBuilder(element.length() + "Service".length());
        for (String part : last2 = element.split("_")) {
            if (part.isEmpty()) break;
            nameBuilder.append(Character.toUpperCase(part.charAt(0))).append(part, 1, part.length());
        }
        nameBuilder.append("Service");
        return nameBuilder.toString();
    }

    private static String buildClassName(String[] elts, int firstElement, int end2, String simpleName) {
        StringBuilder nameBuilder = new StringBuilder();
        for (int offset2 = firstElement; offset2 < end2; ++offset2) {
            if (elts[offset2].isEmpty()) continue;
            nameBuilder.append(elts[offset2].toLowerCase()).append('.');
        }
        nameBuilder.append(simpleName);
        return nameBuilder.toString();
    }

    private static ClassExtensionLibrary tryServiceLoad(Ruby runtime, String className) {
        String classFile = className.replaceAll("\\.", "/") + ".class";
        try {
            URL resource2 = runtime.getJRubyClassLoader().getResource(classFile);
            if (resource2 != null) {
                Class theClass = runtime.getJavaSupport().loadJavaClass(className);
                return new ClassExtensionLibrary(className + ".java", theClass);
            }
        }
        catch (ClassNotFoundException cnfe) {
            if (runtime.isDebug()) {
                cnfe.printStackTrace();
            }
        }
        catch (UnsupportedClassVersionError ucve) {
            if (runtime.isDebug()) {
                ucve.printStackTrace();
            }
            throw runtime.newLoadError("JRuby ext built for wrong Java version in `" + className + "': " + ucve, className);
        }
        return null;
    }

    public ClassExtensionLibrary(String name2, Class extension) {
        this.theClass = extension;
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void load(Ruby runtime, boolean wrap2) {
        if (BasicLibraryService.class.isAssignableFrom(this.theClass)) {
            try {
                runtime.loadExtension(this.name, (BasicLibraryService)this.theClass.newInstance(), wrap2);
            }
            catch (Exception ee) {
                throw new RuntimeException(ee.getMessage(), ee);
            }
        }
    }
}

