/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json.model;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.JSONSingleton;
import mods.quiddity.redux.json.model.Flags;
import mods.quiddity.redux.json.model.Pack;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class Config {
    @Nullable
    protected List<Flags<String, ?>> features;
    @Nullable
    protected List<String> packs;
    private transient List<Pack> parsedPacks;
    private transient List<String> humanPackNames;
    private transient Map<Pack, File> packSourceFileMap;
    private transient Map<String, Pack> idToPack;

    public List<Pack> getPacks() {
        if (this.parsedPacks != null) {
            return this.parsedPacks;
        }
        this.parsedPacks = new ArrayList<Pack>();
        this.humanPackNames = new ArrayList<String>();
        this.packSourceFileMap = new HashMap<Pack, File>();
        this.idToPack = new HashMap<String, Pack>();
        for (String pack2 : this.packs) {
            File file2 = null;
            Pack p2 = null;
            if (new File(Redux.reduxFolder, pack2 + File.separator + "config.json").exists()) {
                file2 = new File(Redux.reduxFolder, pack2 + File.separator + "config.json");
                try {
                    p2 = (Pack)JSONSingleton.getInstance().loadJSON(file2, Pack.class);
                    if (p2 == null) {
                        Redux.instance.getLogger().warn("Enabled Redux pack config file not found. % s does not exist.", new Object[]{Redux.reduxFolder.getAbsolutePath() + pack2 + File.separator + "config.json"});
                    }
                }
                catch (JSONSingleton.JSONLoadException e) {
                    Redux.instance.getLogger().warn("Enabled Redux pack inconsistency. %s is inconsistent. Check the configuration.", new Object[]{pack2 + ".zip"});
                    Redux.instance.getLogger().warn((Message)new FormattedMessage("Redux pack %s will not be loaded.", (Object)pack2, (Object)e));
                }
            } else if (new File(Redux.reduxFolder, pack2 + ".zip").exists()) {
                file2 = new File(Redux.reduxFolder, pack2 + ".zip");
                try {
                    ZipFile packZip = new ZipFile(file2);
                    ZipArchiveEntry packConfig = packZip.getEntry("config.json");
                    if (packConfig != null) {
                        InputStreamReader packZipReader = new InputStreamReader(packZip.getInputStream(packConfig));
                        p2 = (Pack)JSONSingleton.getInstance().loadJSON(packZipReader, Pack.class);
                    }
                    packZip.close();
                }
                catch (Exception e) {
                    Redux.instance.getLogger().warn("Enabled Redux pack inconsistency. %s is inconsistent. Check the configuration.", new Object[]{pack2 + ".zip"});
                    Redux.instance.getLogger().warn((Message)new FormattedMessage("Redux pack %s will not be loaded.", (Object)pack2, (Object)e));
                }
            }
            if (p2 == null) continue;
            this.parsedPacks.add(p2);
            this.humanPackNames.add(p2.getName());
            this.packSourceFileMap.put(p2, file2);
            this.idToPack.put(p2.getId(), p2);
        }
        return this.parsedPacks;
    }

    public List<String> getPackNames() {
        if (this.humanPackNames == null) {
            this.getPacks();
        }
        return ImmutableList.copyOf(this.humanPackNames);
    }

    public File getSourceForPack(Pack p2) {
        if (this.packSourceFileMap == null) {
            this.getPacks();
        }
        return this.packSourceFileMap.get(p2);
    }

    public Pack getPackFromId(String id2) {
        return this.idToPack.get(id2);
    }

    public List<Flags<String, ?>> getFeatures() {
        if (this.features == null) {
            return null;
        }
        return ImmutableList.copyOf(this.features);
    }

    public Flags<String, ?> getFlagForName(String key2) {
        return this.getFlagForName(key2, null);
    }

    public Flags<String, ?> getFlagForName(String key2, Flags<String, ?> defaultValue) {
        if (this.features == null) {
            return null;
        }
        for (Flags flag : ImmutableList.copyOf(this.features)) {
            if (!((String)flag.getKey()).equalsIgnoreCase(key2)) continue;
            return flag;
        }
        return defaultValue;
    }

    public String toString() {
        StringBuilder string2 = new StringBuilder("Enabled Packs: [");
        for (String s2 : this.getPackNames()) {
            string2.append(s2);
            string2.append(',');
        }
        string2.replace(string2.lastIndexOf(","), string2.lastIndexOf(","), "]");
        return string2.toString();
    }
}

