/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import mods.quiddity.redux.ReduxCommandBlockTileEntity;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ReduxEventDispatcher {
    private static ReduxEventDispatcher ourInstance = null;
    private final Map<Trigger.TriggerEvent, List<WeakReference<ReduxCommandBlockTileEntity.ReduxBlockEventReceiver>>> eventListMap = new WeakHashMap<Trigger.TriggerEvent, List<WeakReference<ReduxCommandBlockTileEntity.ReduxBlockEventReceiver>>>();

    public static ReduxEventDispatcher getInstance() {
        if (ourInstance == null) {
            ourInstance = new ReduxEventDispatcher();
        }
        return ourInstance;
    }

    private ReduxEventDispatcher() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerEventReceiver(ReduxCommandBlockTileEntity.ReduxBlockEventReceiver receiver) {
        if (this.eventListMap.get((Object)receiver.getTriggerScript().getTriggerEvent()) == null) {
            this.eventListMap.put(receiver.getTriggerScript().getTriggerEvent(), new ArrayList());
        }
        this.eventListMap.get((Object)receiver.getTriggerScript().getTriggerEvent()).add(new WeakReference<ReduxCommandBlockTileEntity.ReduxBlockEventReceiver>(receiver));
    }

    @SubscribeEvent
    public void onEvent(Event event) {
        if (this.eventListMap.get((Object)Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass())) != null) {
            ImmutableList weakReferences = ImmutableList.copyOf((Collection)this.eventListMap.get((Object)Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass())));
            for (WeakReference eventReceiverWeakReference : weakReferences) {
                ReduxCommandBlockTileEntity.ReduxBlockEventReceiver eventReceiver = (ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)eventReceiverWeakReference.get();
                if (eventReceiver == null) {
                    this.eventListMap.get((Object)Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass())).remove(eventReceiverWeakReference);
                    continue;
                }
                eventReceiver.receiveEvent(event);
            }
        }
    }
}

