/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import mods.quiddity.redux.ReduxCommands;
import mods.quiddity.redux.ReduxLogger;
import mods.quiddity.redux.json.JSONSingleton;
import mods.quiddity.redux.json.model.Config;
import mods.quiddity.redux.loader.ReduxPackLoader;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="redux", version="${version}")
public class Redux {
    public static final String MODID = "redux";
    public static final String VERSION = "${version}";
    public static final String GROUP = "mods/quiddity";
    public static File reduxFolder;
    @Mod.Instance(value="redux")
    public static Redux instance;
    private Config reduxConfiguration = null;
    private final ReduxLogger logger = new ReduxLogger("redux");

    public Redux() {
        instance = this;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        reduxFolder = new File(event.getModConfigurationDirectory(), MODID);
        if (!reduxFolder.exists()) {
            reduxFolder.mkdirs();
        }
        try {
            this.reduxConfiguration = JSONSingleton.getInstance().loadConfig();
        }
        catch (JSONSingleton.JSONLoadException e) {
            this.logger.fatal("Error loading configuration!", e);
        }
        this.logger.loadConfigLevel();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        File defaultPack = new File(reduxFolder, "default_pack.zip");
        if (!defaultPack.exists()) {
            try {
                Redux.copyResource("mods/quiddity/redux/json/model/default_pack.zip", defaultPack);
            }
            catch (IOException e) {
                FMLCommonHandler.instance().raiseException((Throwable)e, "Redux: Error copying default Redux pack!", true);
            }
        }
        new ReduxPackLoader(this.reduxConfiguration).loadPacks();
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        for (ICommand command : ReduxCommands.getCommands()) {
            event.registerServerCommand(command);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Config getReduxConfiguration() {
        return this.reduxConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(String sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        Channel source = null;
        AbstractInterruptibleChannel destination = null;
        FileOutputStream fileOutput = null;
        InputStream resource = null;
        try {
            resource = Redux.class.getClassLoader().getResourceAsStream(sourceFile);
            source = Channels.newChannel(resource);
            fileOutput = new FileOutputStream(destFile);
            destination = fileOutput.getChannel();
            ((FileChannel)destination).transferFrom((ReadableByteChannel)source, 0L, resource.available());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
            if (fileOutput != null) {
                fileOutput.close();
            }
            if (resource != null) {
                resource.close();
            }
        }
    }

    static {
        instance = null;
    }
}

