/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mods.quiddity.redux.ReduxBlock;
import mods.quiddity.redux.ReduxCommandBlockTileEntity;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;

public class ReduxCommands {
    public static final ReduxCommand TEST_FOR_TRIGGER = new ReduxCommand("testfortrigger", "/testfortrigger <trigger type>", new ReduxCommandRunnable(){

        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            block5: {
                if (args.length < 1) {
                    throw new CommandException("Incorrect parameters", new Object[0]);
                }
                String trigger = args[0];
                try {
                    Trigger.TriggerEvent event = Trigger.TriggerEvent.valueOf(trigger);
                    if (event == null) break block5;
                    if (sender instanceof ReduxCommandBlockTileEntity.ReduxBlockEventReceiver) {
                        ReduxCommandBlockTileEntity.ReduxBlockEventReceiver reduxBlockEventReceiver = (ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)sender;
                        if (Trigger.TriggerEvent.getTriggerEventFromForgeEvent(reduxBlockEventReceiver.getLastEvent().getClass()) == event) {
                            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, 1);
                            return;
                        }
                        break block5;
                    }
                    throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
                }
                catch (IllegalArgumentException ignored) {
                    throw new CommandException("Trigger type %s does not exist!", new Object[]{trigger});
                }
            }
            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, 0);
        }
    });
    public static final ReduxCommand TEST_FOR_PROPERTY = new ReduxCommand("testforproperty", "/testforproperty <property name> <integer value>", new ReduxCommandRunnable(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            int testValue;
            if (args.length < 2) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            try {
                testValue = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("Second parameter must be an integer!", new Object[0]);
            }
            if (!(sender instanceof ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)) throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
            ReduxCommandBlockTileEntity.ReduxBlockEventReceiver reduxBlockEventReceiver = (ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)sender;
            IBlockState blockState = sender.func_130014_f_().func_180495_p(reduxBlockEventReceiver.func_180425_c());
            if (!(blockState.func_177230_c() instanceof ReduxBlock)) throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
            PropertyInteger property = ((ReduxBlock)blockState.func_177230_c()).getPropertyFromName(args[0]);
            if (property != null && blockState.func_177229_b((IProperty)property) != null && blockState.func_177229_b((IProperty)property).equals(testValue)) {
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, (Integer)blockState.func_177229_b((IProperty)property) > 15 ? 15 : (Integer)blockState.func_177229_b((IProperty)property));
            }
            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, 0);
        }
    });
    public static final ReduxCommand SET_PROPERTY = new ReduxCommand("setproperty", "/setproperty <property name> <integer value>", new ReduxCommandRunnable(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            int setValue;
            if (args.length < 2) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            try {
                setValue = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("Second parameter must be an integer!", new Object[0]);
            }
            if (!(sender instanceof ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)) throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
            ReduxCommandBlockTileEntity.ReduxBlockEventReceiver reduxBlockEventReceiver = (ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)sender;
            IBlockState blockState = sender.func_130014_f_().func_180495_p(reduxBlockEventReceiver.func_180425_c());
            if (!(blockState.func_177230_c() instanceof ReduxBlock)) throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
            PropertyInteger property = ((ReduxBlock)blockState.func_177230_c()).getPropertyFromName(args[0]);
            if (property != null && blockState.func_177229_b((IProperty)property) != null) {
                reduxBlockEventReceiver.func_130014_f_().func_175656_a(reduxBlockEventReceiver.func_180425_c(), blockState.func_177226_a((IProperty)property, (Comparable)Integer.valueOf(setValue)));
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, 1);
            }
            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, 0);
        }
    });
    private static final List<ICommand> commands = new ArrayList<ICommand>();

    public static List<ICommand> getCommands() {
        return ImmutableList.copyOf(commands);
    }

    static {
        commands.add((ICommand)TEST_FOR_TRIGGER);
        commands.add((ICommand)TEST_FOR_PROPERTY);
        commands.add((ICommand)SET_PROPERTY);
    }

    public static class ReduxCommand
    extends CommandBase {
        private final String name;
        private final String commandUsage;
        private final ReduxCommandRunnable commandRunnable;

        public ReduxCommand(String name, String usage, ReduxCommandRunnable runnable) {
            this.name = name;
            this.commandUsage = usage;
            this.commandRunnable = runnable;
        }

        public String func_71517_b() {
            return this.name;
        }

        public String func_71518_a(ICommandSender sender) {
            return this.commandUsage;
        }

        public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
            this.commandRunnable.run(sender, args);
        }
    }

    private static abstract class ReduxCommandRunnable {
        private ReduxCommandRunnable() {
        }

        public abstract void run(ICommandSender var1, String ... var2) throws CommandException;
    }
}

