/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.loader;

import com.google.common.collect.Sets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.loader.ReduxPackModContainer;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ModContainer;

public class ReduxResourcePack
implements IResourcePack {
    private final ReduxPackModContainer reduxModPack;

    public ReduxResourcePack(ModContainer reduxPackModContainer) {
        this.reduxModPack = reduxPackModContainer instanceof ReduxPackModContainer ? (ReduxPackModContainer)reduxPackModContainer : null;
        assert (this.reduxModPack == null);
    }

    public InputStream func_110590_a(ResourceLocation resource) throws IOException {
        ZipFile reduxPackZip;
        ZipEntry requestedResource;
        if (!this.checkSandbox(resource.func_110623_a())) {
            return null;
        }
        InputStream resourceStream = null;
        if (this.reduxModPack.getSource().isDirectory()) {
            resourceStream = new FileInputStream(new File(this.reduxModPack.getSource(), resource.func_110623_a()));
        } else if (this.reduxModPack.getSource().isFile() && (requestedResource = (reduxPackZip = new ZipFile(this.reduxModPack.getSource())).getEntry(resource.func_110623_a())) != null) {
            resourceStream = reduxPackZip.getInputStream(requestedResource);
        }
        return resourceStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_110589_b(ResourceLocation resource) {
        if (!this.checkSandbox(resource.func_110623_a())) {
            return false;
        }
        boolean resourceExists = false;
        if (this.reduxModPack.getSource().isDirectory()) {
            resourceExists = new File(this.reduxModPack.getSource(), resource.func_110623_a()).exists();
        } else if (this.reduxModPack.getSource().isFile()) {
            ZipFile reduxPackZip = null;
            try {
                reduxPackZip = new ZipFile(this.reduxModPack.getSource());
                resourceExists = reduxPackZip.getEntry(resource.func_110623_a()) != null;
            }
            catch (IOException e) {
                Redux.instance.getLogger().warn("Redux pack inconsistency. %s is inconsistent.", new Object[]{resource.func_110624_b() + ".zip"});
            }
            finally {
                if (reduxPackZip != null) {
                    try {
                        reduxPackZip.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return resourceExists;
    }

    public Set func_110587_b() {
        return Sets.newHashSet((Object[])new String[]{this.reduxModPack.getModId()});
    }

    public IMetadataSection func_135058_a(IMetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return this.reduxModPack.getName();
    }

    private boolean checkSandbox(String resource) {
        if (resource.contains("..") || resource.startsWith("/") || resource.charAt(1) == ':') {
            Redux.instance.getLogger().warn("Critical security error! Tried to access file(s) outside of the Redux config folder with the path of: %s\nWill deny requested file.", new Object[]{resource});
            return false;
        }
        return true;
    }
}

