/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.util;

import dnoved1.immersify.Redux;
import dnoved1.immersify.api.property.Property;
import dnoved1.immersify.api.property.PropertyCompound;
import dnoved1.immersify.api.property.PropertyEmpty;
import dnoved1.immersify.api.property.PropertyNumber;
import dnoved1.immersify.api.property.PropertyString;
import dnoved1.immersify.graphics.gui.GuiTrace;
import dnoved1.immersify.graphics.gui.IClickableGui;
import dnoved1.immersify.util.MathHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class UtilMethods {
    public static Property convertNBTToProperty(NBTBase nbt) {
        if (nbt instanceof NBTTagByte) {
            return new PropertyNumber<Byte>(nbt.func_74740_e(), ((NBTTagByte)nbt).field_74756_a);
        }
        if (nbt instanceof NBTTagByteArray) {
            byte[] pBytes = ((NBTTagByteArray)nbt).field_74754_a;
            Byte[] oBytes = new Byte[pBytes.length];
            for (int i = 0; i < pBytes.length; ++i) {
                oBytes[i] = pBytes[i];
            }
            return new PropertyCompound<Byte>(nbt.func_74740_e(), oBytes);
        }
        if (nbt instanceof NBTTagCompound) {
            Collection tags = ((NBTTagCompound)nbt).func_74758_c();
            if (tags.size() == 0) {
                return null;
            }
            if (tags.size() == 1) {
                return UtilMethods.convertNBTToProperty((NBTBase)tags.iterator().next());
            }
            ArrayList<Property> propertyList = new ArrayList<Property>();
            for (NBTBase tag : tags) {
                propertyList.add(UtilMethods.convertNBTToProperty(tag));
            }
            return new PropertyCompound(nbt.func_74740_e(), propertyList.toArray((T[])null));
        }
        if (nbt instanceof NBTTagDouble) {
            return new PropertyNumber<Double>(nbt.func_74740_e(), ((NBTTagDouble)nbt).field_74755_a);
        }
        if (nbt instanceof NBTTagEnd) {
            return new PropertyEmpty(nbt.func_74740_e());
        }
        if (nbt instanceof NBTTagFloat) {
            return new PropertyNumber<Float>(nbt.func_74740_e(), Float.valueOf(((NBTTagFloat)nbt).field_74750_a));
        }
        if (nbt instanceof NBTTagInt) {
            return new PropertyNumber<Integer>(nbt.func_74740_e(), ((NBTTagInt)nbt).field_74748_a);
        }
        if (nbt instanceof NBTTagIntArray) {
            int[] pInts = ((NBTTagIntArray)nbt).field_74749_a;
            Integer[] oInts = new Integer[pInts.length];
            for (int i = 0; i < pInts.length; ++i) {
                oInts[i] = pInts[i];
            }
            return new PropertyCompound<Integer>(nbt.func_74740_e(), oInts);
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList tagList = (NBTTagList)nbt;
            if (tagList.func_74745_c() == 0) {
                return null;
            }
            if (tagList.func_74745_c() == 1) {
                return UtilMethods.convertNBTToProperty(tagList.func_74743_b(0));
            }
            ArrayList<Property> propertyList = new ArrayList<Property>();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                propertyList.add(UtilMethods.convertNBTToProperty(tagList.func_74743_b(i)));
            }
            return new PropertyCompound(nbt.func_74740_e(), propertyList.toArray((T[])null));
        }
        if (nbt instanceof NBTTagLong) {
            return new PropertyNumber<Long>(nbt.func_74740_e(), ((NBTTagLong)nbt).field_74753_a);
        }
        if (nbt instanceof NBTTagShort) {
            return new PropertyNumber<Short>(nbt.func_74740_e(), ((NBTTagShort)nbt).field_74752_a);
        }
        if (nbt instanceof NBTTagString) {
            return new PropertyString(nbt.func_74740_e(), ((NBTTagString)nbt).field_74751_a);
        }
        return null;
    }

    public static EntityPlayer getPlayerFromID(World world, int entityID) {
        for (Object o : world.field_73010_i) {
            if (!(o instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)o;
            if (player.field_70157_k != entityID) continue;
            return player;
        }
        return null;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(EntityPlayer player, boolean shouldCollide, float reach) {
        Vec3 position = player.field_70170_p.func_82732_R().func_72345_a(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() + (double)(player.field_70170_p.field_72995_K ? -player.getDefaultEyeHeight() : 0.0f), player.field_70161_v);
        float horizontalVectorFactor = -MathHelper.cos(-MathHelper.convertD2R(player.field_70125_A));
        float vectorAngleY = MathHelper.sin(-MathHelper.convertD2R(player.field_70125_A));
        float vectorAngleX = MathHelper.sin((double)(-MathHelper.convertD2R(player.field_70177_z)) - Math.PI) * horizontalVectorFactor;
        float vectorAngleZ = MathHelper.cos((double)(-MathHelper.convertD2R(player.field_70177_z)) - Math.PI) * horizontalVectorFactor;
        Vec3 lineOfSight = position.func_72441_c((double)vectorAngleX * (double)reach, (double)vectorAngleY * (double)reach, (double)vectorAngleZ * (double)reach);
        return player.field_70170_p.func_72831_a(position, lineOfSight, shouldCollide, !shouldCollide);
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(EntityPlayer player, boolean shouldCollide) {
        float reach = 5.0f;
        if (player instanceof EntityPlayerMP) {
            reach = (float)((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        return UtilMethods.getMovingObjectPositionFromPlayer(player, shouldCollide, reach);
    }

    public static boolean areItemsSame(ItemStack a, ItemStack b) {
        return a.func_77969_a(b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static void getMouseOver(float partialTick) {
        int i;
        double reach;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71451_h == null || mc.field_71441_e == null) {
            return;
        }
        Entity pointedEntity = null;
        mc.field_96291_i = null;
        Redux.INSTANCE.guiTrace = null;
        double blockHitDistance = reach = (double)mc.field_71442_b.func_78757_d();
        mc.field_71476_x = mc.field_71451_h.func_70614_a(reach, partialTick);
        Vec3 eyePosition = mc.field_71451_h.func_70666_h(partialTick);
        if (mc.field_71442_b.func_78749_i()) {
            reach = 6.0;
        } else if (reach > 3.0) {
            reach = 3.0;
        }
        blockHitDistance = mc.field_71476_x == null ? reach : mc.field_71476_x.field_72307_f.func_72438_d(eyePosition);
        Vec3 lookVector = mc.field_71451_h.func_70676_i(partialTick);
        Vec3 reachVector = eyePosition.func_72441_c(lookVector.field_72450_a * reach, lookVector.field_72448_b * reach, lookVector.field_72449_c * reach);
        float expansionFactor = 1.0f;
        List entitiesInVision = mc.field_71441_e.func_72839_b((Entity)mc.field_71451_h, mc.field_71451_h.field_70121_D.func_72321_a(lookVector.field_72450_a * reach, lookVector.field_72448_b * reach, lookVector.field_72449_c * reach).func_72314_b((double)expansionFactor, (double)expansionFactor, (double)expansionFactor));
        double closestHit = blockHitDistance;
        for (i = 0; i < entitiesInVision.size(); ++i) {
            double lookDistance;
            Entity entity = (Entity)entitiesInVision.get(i);
            if (!entity.func_70067_L()) continue;
            float extraCollision = entity.func_70111_Y();
            AxisAlignedBB entityAABB = entity.field_70121_D.func_72314_b((double)extraCollision, (double)extraCollision, (double)extraCollision);
            if (entityAABB.func_72318_a(eyePosition) && Double.compare(closestHit, 0.0) >= 0) {
                pointedEntity = entity;
                closestHit = 0.0;
                continue;
            }
            MovingObjectPosition mop = entityAABB.func_72327_a(eyePosition, reachVector);
            if (mop == null || !(closestHit > (lookDistance = eyePosition.func_72438_d(mop.field_72307_f))) && Double.compare(closestHit, 0.0) != 0) continue;
            if (entity == mc.field_71451_h.field_70154_o && !entity.canRiderInteract()) {
                if (Double.compare(closestHit, 0.0) != 0) continue;
                pointedEntity = entity;
                continue;
            }
            pointedEntity = entity;
            closestHit = lookDistance;
        }
        if (closestHit > 0.0) {
            for (i = 0; i < Redux.INSTANCE.clickableGuis.size(); ++i) {
                IClickableGui gui = Redux.INSTANCE.clickableGuis.get(i);
                Vec3 farthestHit = eyePosition.func_72441_c(lookVector.field_72450_a * closestHit, lookVector.field_72448_b * closestHit, lookVector.field_72449_c * closestHit);
                Vec3 pointOnPlane = gui.getPointOnPlane();
                Vec3 normalVector = gui.getNormalVector();
                double s1 = (normalVector.field_72450_a * (pointOnPlane.field_72450_a - eyePosition.field_72450_a) + normalVector.field_72448_b * (pointOnPlane.field_72448_b - eyePosition.field_72448_b) + normalVector.field_72449_c * (pointOnPlane.field_72449_c - eyePosition.field_72449_c)) / (normalVector.field_72450_a * (farthestHit.field_72450_a - eyePosition.field_72450_a) + normalVector.field_72448_b * (farthestHit.field_72448_b - eyePosition.field_72448_b) + normalVector.field_72449_c * (farthestHit.field_72449_c - eyePosition.field_72449_c));
                if (!(s1 > 0.0) || !(s1 < 1.0)) continue;
                Vec3 pointHit = Vec3.func_72443_a((double)(eyePosition.field_72450_a + s1 * (farthestHit.field_72450_a - eyePosition.field_72450_a)), (double)(eyePosition.field_72448_b + s1 * (farthestHit.field_72448_b - eyePosition.field_72448_b)), (double)(eyePosition.field_72449_c + s1 * (farthestHit.field_72449_c - eyePosition.field_72449_c)));
                GuiTrace guiTrace = new GuiTrace(gui, pointHit.field_72450_a - pointOnPlane.field_72450_a, pointHit.field_72448_b - pointOnPlane.field_72448_b, pointHit.field_72449_c - pointOnPlane.field_72449_c);
                if (!gui.isTraceWithinBounds(guiTrace)) continue;
                Redux.INSTANCE.guiTrace = new GuiTrace(gui, pointHit.field_72450_a - pointOnPlane.field_72450_a, pointHit.field_72448_b - pointOnPlane.field_72448_b, pointHit.field_72449_c - pointOnPlane.field_72449_c);
                closestHit = s1;
            }
        }
        if (Redux.INSTANCE.guiTrace != null && pointedEntity != null && (closestHit < blockHitDistance || mc.field_71476_x == null)) {
            mc.field_71476_x = new MovingObjectPosition(pointedEntity);
            if (pointedEntity instanceof EntityLivingBase) {
                mc.field_96291_i = (EntityLivingBase)pointedEntity;
            }
        }
    }
}

