/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.recipe;

import dnoved1.immersify.Redux;
import dnoved1.immersify.api.IRecipe;
import dnoved1.immersify.api.property.Property;
import dnoved1.immersify.recipe.CampfireRecipe;
import dnoved1.immersify.recipe.CombinationRecipe;
import dnoved1.immersify.recipe.CookingRecipe;
import dnoved1.immersify.recipe.ShapingRecipe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeManager {
    private static ArrayList<IRecipe> recipes = new ArrayList();

    public static IRecipe getFirstMatchingRecipe(Property ... properties) {
        for (IRecipe recipe : recipes) {
            if (!recipe.matches(properties)) continue;
            return recipe;
        }
        return null;
    }

    public static void addRecipe(IRecipe recipe) {
        recipes.add(recipe);
    }

    private static void addCombinationRecipe(ItemStack[] ingredients, ItemStack result) {
        recipes.add(new CombinationRecipe(ingredients, result));
    }

    private static void addShapingRecipe(ItemStack tool, ItemStack[] ingredients, ItemStack result) {
        recipes.add(new ShapingRecipe(ingredients, tool, result));
    }

    private static void addCookingRecipe(ItemStack ingredient, ItemStack result) {
        recipes.add(new CookingRecipe(ingredient, result));
    }

    static {
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71949_H), new ItemStack(Item.field_77703_o));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71941_G), new ItemStack(Item.field_77717_p));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_72073_aw), new ItemStack(Item.field_77702_n));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71939_E), new ItemStack(Block.field_71946_M));
        RecipeManager.addCookingRecipe(new ItemStack(Item.field_77784_aq), new ItemStack(Item.field_77782_ar));
        RecipeManager.addCookingRecipe(new ItemStack(Item.field_77741_bi), new ItemStack(Item.field_77734_bj));
        RecipeManager.addCookingRecipe(new ItemStack(Item.field_77735_bk), new ItemStack(Item.field_77736_bl));
        RecipeManager.addCookingRecipe(new ItemStack(Item.field_77754_aU), new ItemStack(Item.field_77753_aV));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71978_w), new ItemStack(Block.field_71981_t));
        RecipeManager.addCookingRecipe(new ItemStack(Item.field_77757_aI), new ItemStack(Item.field_77772_aH));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_72038_aV), new ItemStack(Item.field_77756_aW, 1, 2));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71951_J, 1, 0), new ItemStack(Item.field_77705_m, 1, 1));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71951_J, 1, 1), new ItemStack(Item.field_77705_m, 1, 1));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71951_J, 1, 2), new ItemStack(Item.field_77705_m, 1, 1));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71951_J, 1, 3), new ItemStack(Item.field_77705_m, 1, 1));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71950_I), new ItemStack(Item.field_77705_m));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_72047_aN), new ItemStack(Item.field_77767_aC));
        RecipeManager.addCookingRecipe(new ItemStack(Block.field_71947_N), new ItemStack(Item.field_77756_aW, 1, 4));
        RecipeManager.addRecipe(new CampfireRecipe(new ItemStack[]{new ItemStack(Item.field_77669_D), new ItemStack(Item.field_77669_D)}));
        RecipeManager.addRecipe(new CombinationRecipe(new ItemStack[]{new ItemStack(Block.field_71979_v), new ItemStack(Block.field_71939_E)}, new ItemStack(Block.field_72073_aw)));
        RecipeManager.addCombinationRecipe(new ItemStack[]{new ItemStack(Block.field_71979_v), new ItemStack(Item.field_77690_S)}, new ItemStack((Item)Redux.BACKPACK));
        RecipeManager.addCombinationRecipe(new ItemStack[]{new ItemStack(Item.field_77669_D), new ItemStack(Item.field_77804_ap)}, new ItemStack(Item.field_77710_w));
        RecipeManager.addCombinationRecipe(new ItemStack[]{new ItemStack(Item.field_77669_D), new ItemStack(Item.field_77804_ap), new ItemStack(Item.field_77804_ap)}, new ItemStack(Item.field_77719_y));
        RecipeManager.addCombinationRecipe(new ItemStack[]{new ItemStack(Item.field_77669_D), new ItemStack(Item.field_77804_ap), new ItemStack(Item.field_77804_ap), new ItemStack(Item.field_77804_ap)}, new ItemStack(Item.field_77720_x));
        RecipeManager.addCombinationRecipe(new ItemStack[]{new ItemStack(Item.field_77669_D), new ItemStack(Item.field_77705_m)}, new ItemStack(Block.field_72069_aq, 4));
        RecipeManager.addCombinationRecipe(new ItemStack[]{new ItemStack(Item.field_77669_D), new ItemStack(Item.field_77705_m, 1, 1)}, new ItemStack(Block.field_72069_aq, 4));
        RecipeManager.addShapingRecipe(null, new ItemStack[]{new ItemStack(Block.field_71940_F)}, new ItemStack(Item.field_77804_ap));
        RecipeManager.addShapingRecipe(new ItemStack(Item.field_77719_y), new ItemStack[]{new ItemStack(Block.field_71951_J, 1, 0)}, new ItemStack(Block.field_71988_x, 4, 0));
        RecipeManager.addShapingRecipe(new ItemStack(Item.field_77719_y), new ItemStack[]{new ItemStack(Block.field_71951_J, 1, 1)}, new ItemStack(Block.field_71988_x, 4, 1));
        RecipeManager.addShapingRecipe(new ItemStack(Item.field_77719_y), new ItemStack[]{new ItemStack(Block.field_71951_J, 1, 2)}, new ItemStack(Block.field_71988_x, 4, 2));
        RecipeManager.addShapingRecipe(new ItemStack(Item.field_77719_y), new ItemStack[]{new ItemStack(Block.field_71951_J, 1, 3)}, new ItemStack(Block.field_71988_x, 4, 3));
        RecipeManager.addShapingRecipe(new ItemStack(Item.field_77719_y), new ItemStack[]{new ItemStack(Block.field_71988_x, 1, 0)}, new ItemStack(Item.field_77669_D, 2));
        RecipeManager.addShapingRecipe(new ItemStack(Item.field_77719_y), new ItemStack[]{new ItemStack(Block.field_71988_x, 1, 1)}, new ItemStack(Item.field_77669_D, 2));
        RecipeManager.addShapingRecipe(new ItemStack(Item.field_77719_y), new ItemStack[]{new ItemStack(Block.field_71988_x, 1, 2)}, new ItemStack(Item.field_77669_D, 2));
        RecipeManager.addShapingRecipe(new ItemStack(Item.field_77719_y), new ItemStack[]{new ItemStack(Block.field_71988_x, 1, 3)}, new ItemStack(Item.field_77669_D, 2));
    }
}

