/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.plugins.minefactoryreloaded.plantables;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;

public class PlantableStandard
implements IFactoryPlantable {
    protected Item _sourceId;
    protected Block _plantedBlockId;

    public PlantableStandard(Item sourceId, Block plantedBlockId) {
        this._sourceId = sourceId;
        this._plantedBlockId = plantedBlockId;
    }

    public boolean canBePlanted(ItemStack stack, boolean forFermenting) {
        return true;
    }

    public boolean canBePlantedHere(World world, int x, int y, int z, ItemStack stack) {
        Block groundId = world.getBlock(x, y - 1, z);
        if (!world.isAirBlock(x, y, z)) {
            return false;
        }
        return this._plantedBlockId.canPlaceBlockAt(world, x, y, z) && this._plantedBlockId.canBlockStay(world, x, y, z) || this._plantedBlockId instanceof IPlantable && groundId != null && groundId.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)this._plantedBlockId);
    }

    public void prePlant(World world, int x, int y, int z, ItemStack stack) {
    }

    public void postPlant(World world, int x, int y, int z, ItemStack stack) {
    }

    public ReplacementBlock getPlantedBlock(World world, int x, int y, int z, ItemStack stack) {
        if (stack.getItem() != this._sourceId) {
            return new ReplacementBlock(Blocks.air);
        }
        return new ReplacementBlock(this._plantedBlockId).setMeta(this.getMeta(stack));
    }

    public Item getSeed() {
        return this._sourceId;
    }

    public int getMeta(ItemStack i) {
        return i.getItemDamage();
    }
}

