/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.Natura;
import mods.natura.common.NaturaTab;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class NetherBerryItem
extends ItemFood {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"blight", "dusk", "sky", "sting"};

    public NetherBerryItem(int heal) {
        super(heal, 0.4f, false);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer player) {
        if (player.canEat(true) && player.getFoodStats().getSaturationLevel() < 18.0f) {
            player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        }
        return par1ItemStack;
    }

    protected void onFoodEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            int duration = 0;
            switch (stack.getItemDamage()) {
                case 0: {
                    PotionEffect potion = player.getActivePotionEffect(Potion.regeneration);
                    if (potion != null) {
                        duration = potion.getDuration();
                    }
                    player.addPotionEffect(new PotionEffect(Potion.regeneration.id, duration + 160, 0));
                    if (Natura.random.nextFloat() < 0.75f) {
                        potion = player.getActivePotionEffect(Potion.poison);
                        duration = potion != null ? potion.getDuration() : 0;
                        player.addPotionEffect(new PotionEffect(Potion.poison.id, duration + 100, 0));
                    }
                    if (!(Natura.random.nextFloat() < 0.15f)) break;
                    potion = player.getActivePotionEffect(Potion.wither);
                    duration = potion != null ? potion.getDuration() : 0;
                    player.addPotionEffect(new PotionEffect(Potion.wither.id, duration + 100, 0));
                    break;
                }
                case 1: {
                    PotionEffect potion = player.getActivePotionEffect(Potion.nightVision);
                    if (potion != null) {
                        duration = potion.getDuration();
                    }
                    player.addPotionEffect(new PotionEffect(Potion.nightVision.id, duration + 300, 0));
                    if (!(Natura.random.nextFloat() < 0.75f)) break;
                    potion = player.getActivePotionEffect(Potion.blindness);
                    duration = potion != null ? potion.getDuration() : 0;
                    player.addPotionEffect(new PotionEffect(Potion.blindness.id, duration + 60, 0));
                    break;
                }
                case 2: {
                    PotionEffect potion = player.getActivePotionEffect(Potion.jump);
                    if (potion != null) {
                        duration = potion.getDuration();
                    }
                    player.addPotionEffect(new PotionEffect(Potion.jump.id, duration + 160, 0));
                    if (!(Natura.random.nextFloat() < 0.75f)) break;
                    potion = player.getActivePotionEffect(Potion.moveSlowdown);
                    duration = potion != null ? potion.getDuration() : 0;
                    player.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, duration + 60, 0));
                    break;
                }
                case 3: {
                    PotionEffect potion = player.getActivePotionEffect(Potion.damageBoost);
                    if (potion != null) {
                        duration = potion.getDuration();
                    }
                    player.addPotionEffect(new PotionEffect(Potion.damageBoost.id, duration + 200, 0));
                    if (!(Natura.random.nextFloat() < 0.75f)) break;
                    potion = player.getActivePotionEffect(Potion.digSlowdown);
                    duration = potion != null ? potion.getDuration() : 0;
                    player.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, duration + 200, 0));
                    break;
                }
                case 4: {
                    PotionEffect potion = player.getActivePotionEffect(Potion.digSpeed);
                    if (potion != null) {
                        duration = potion.getDuration();
                    }
                    player.addPotionEffect(new PotionEffect(Potion.digSpeed.id, duration + 200, 0));
                    if (!(Natura.random.nextFloat() < 0.75f)) break;
                    potion = player.getActivePotionEffect(Potion.weakness);
                    duration = potion != null ? potion.getDuration() : 0;
                    player.addPotionEffect(new PotionEffect(Potion.weakness.id, duration + 200, 0));
                }
            }
        }
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 24;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:berry_" + this.textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush1"));
        switch (stack.getItemDamage() % 4) {
            case 0: {
                list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush2"));
                break;
            }
            case 1: {
                list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush3"));
                break;
            }
            case 2: {
                list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush4"));
                break;
            }
            case 3: {
                list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush5"));
            }
        }
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return "item.berry." + this.textureNames[itemstack.getItemDamage()];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 4; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }
}

