/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NaturaTab;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BerryItem
extends ItemFood {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"rasp", "blue", "black", "geo"};

    public BerryItem(int heal) {
        super(heal, 0.4f, false);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
        this.setAlwaysEdible();
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer player) {
        if (player.canEat(true) && player.getFoodStats().getSaturationLevel() < 18.0f) {
            player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        }
        return par1ItemStack;
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 16;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:berry_" + this.textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.translateToLocal((String)"tooltip.berry"));
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return "item.berry." + this.textureNames[itemstack.getItemDamage()];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 4; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }
}

