/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LogTwoxTwo
extends Block {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"bark", "heart_small", "upper_left", "upper_right", "side_left", "side_right", "lower_left", "lower_right"};

    public LogTwoxTwo(float hardness, Material material) {
        super(material);
        this.setHardness(hardness);
        this.setStepSound(Block.soundTypeMetal);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:bloodwood_" + this.textureNames[i]);
        }
    }

    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return Item.getItemFromBlock((Block)NContent.bloodwood);
    }

    public int damageDropped(int meta) {
        if (meta < 12) {
            return 0;
        }
        if (meta == 15) {
            return 15;
        }
        return 12;
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return false;
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
        int b0 = 4;
        int j1 = b0 + 1;
        if (par1World.checkChunksExist(par2 - j1, par3 - j1, par4 - j1, par2 + j1, par3 + j1, par4 + j1)) {
            for (int k1 = -b0; k1 <= b0; ++k1) {
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        Block j2 = par1World.getBlock(par2 + k1, par3 + l1, par4 + i2);
                        if (j2 == null) continue;
                        j2.beginLeavesDecay(par1World, par2 + k1, par3 + l1, par4 + i2);
                    }
                }
            }
        }
    }

    public int getRenderType() {
        return 31;
    }

    protected ItemStack createStackedBlock(int par1) {
        return new ItemStack((Block)this, 1, LogTwoxTwo.limitToValidMetadata(par1));
    }

    public static int limitToValidMetadata(int par0) {
        return par0 & 3;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta == 15) {
            return this.icons[0];
        }
        if (meta == 0) {
            switch (side) {
                case 0: {
                    return this.icons[2];
                }
                case 1: {
                    return this.icons[2];
                }
                case 2: {
                    return this.icons[0];
                }
                case 3: {
                    return this.icons[4];
                }
                case 4: {
                    return this.icons[0];
                }
                case 5: {
                    return this.icons[5];
                }
            }
        }
        if (meta == 1) {
            switch (side) {
                case 0: {
                    return this.icons[3];
                }
                case 1: {
                    return this.icons[3];
                }
                case 2: {
                    return this.icons[0];
                }
                case 3: {
                    return this.icons[5];
                }
                case 4: {
                    return this.icons[4];
                }
                case 5: {
                    return this.icons[0];
                }
            }
        }
        if (meta == 2) {
            switch (side) {
                case 0: {
                    return this.icons[6];
                }
                case 1: {
                    return this.icons[6];
                }
                case 2: {
                    return this.icons[5];
                }
                case 3: {
                    return this.icons[0];
                }
                case 4: {
                    return this.icons[0];
                }
                case 5: {
                    return this.icons[4];
                }
            }
        }
        if (meta == 3) {
            switch (side) {
                case 0: {
                    return this.icons[7];
                }
                case 1: {
                    return this.icons[7];
                }
                case 2: {
                    return this.icons[4];
                }
                case 3: {
                    return this.icons[0];
                }
                case 4: {
                    return this.icons[5];
                }
                case 5: {
                    return this.icons[0];
                }
            }
        }
        if (meta == 4) {
            switch (side) {
                case 0: {
                    return this.icons[4];
                }
                case 1: {
                    return this.icons[0];
                }
                case 2: {
                    return this.icons[5];
                }
                case 3: {
                    return this.icons[0];
                }
                case 4: {
                    return this.icons[3];
                }
                case 5: {
                    return this.icons[2];
                }
            }
        }
        if (meta == 5) {
            switch (side) {
                case 0: {
                    return this.icons[5];
                }
                case 1: {
                    return this.icons[0];
                }
                case 2: {
                    return this.icons[0];
                }
                case 3: {
                    return this.icons[4];
                }
                case 4: {
                    return this.icons[2];
                }
                case 5: {
                    return this.icons[3];
                }
            }
        }
        if (meta == 6) {
            switch (side) {
                case 0: {
                    return this.icons[0];
                }
                case 1: {
                    return this.icons[5];
                }
                case 2: {
                    return this.icons[4];
                }
                case 3: {
                    return this.icons[0];
                }
                case 4: {
                    return this.icons[7];
                }
                case 5: {
                    return this.icons[6];
                }
            }
        }
        if (meta == 7) {
            switch (side) {
                case 0: {
                    return this.icons[0];
                }
                case 1: {
                    return this.icons[4];
                }
                case 2: {
                    return this.icons[0];
                }
                case 3: {
                    return this.icons[5];
                }
                case 4: {
                    return this.icons[6];
                }
                case 5: {
                    return this.icons[7];
                }
            }
        }
        if (meta == 8) {
            switch (side) {
                case 0: {
                    return this.icons[4];
                }
                case 1: {
                    return this.icons[0];
                }
                case 2: {
                    return this.icons[3];
                }
                case 3: {
                    return this.icons[2];
                }
                case 4: {
                    return this.icons[0];
                }
                case 5: {
                    return this.icons[5];
                }
            }
        }
        if (meta == 9) {
            switch (side) {
                case 0: {
                    return this.icons[5];
                }
                case 1: {
                    return this.icons[0];
                }
                case 2: {
                    return this.icons[2];
                }
                case 3: {
                    return this.icons[3];
                }
                case 4: {
                    return this.icons[4];
                }
                case 5: {
                    return this.icons[0];
                }
            }
        }
        if (meta == 10) {
            switch (side) {
                case 0: {
                    return this.icons[0];
                }
                case 1: {
                    return this.icons[4];
                }
                case 2: {
                    return this.icons[7];
                }
                case 3: {
                    return this.icons[6];
                }
                case 4: {
                    return this.icons[0];
                }
                case 5: {
                    return this.icons[4];
                }
            }
        }
        if (meta == 11) {
            switch (side) {
                case 0: {
                    return this.icons[0];
                }
                case 1: {
                    return this.icons[5];
                }
                case 2: {
                    return this.icons[6];
                }
                case 3: {
                    return this.icons[7];
                }
                case 4: {
                    return this.icons[5];
                }
                case 5: {
                    return this.icons[0];
                }
            }
        }
        return this.icons[0];
    }

    public int onBlockPlaced(World par1World, int blockX, int blockY, int blockZ, int side, float clickX, float clickY, float clickZ, int metadata) {
        if (metadata >= 12) {
            return metadata;
        }
        int meta = metadata & 3;
        int add = 0;
        switch (side) {
            case 0: 
            case 1: {
                add = 0;
                if (clickX > 0.5f) {
                    add = (byte)(add + 1);
                }
                if (!(clickZ > 0.5f)) break;
                add = (byte)(add + 2);
                break;
            }
            case 2: 
            case 3: {
                add = 8;
                if (clickX > 0.5f) {
                    add = (byte)(add + 1);
                }
                if (!(clickY < 0.5f)) break;
                add = (byte)(add + 2);
                break;
            }
            case 4: 
            case 5: {
                add = 4;
                if (clickZ < 0.5f) {
                    add = (byte)(add + 1);
                }
                if (!(clickY < 0.5f)) break;
                add = (byte)(add + 2);
            }
        }
        return meta | add;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 15));
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

