/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TreeBlock
extends BlockLog {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"eucalyptus_bark", "sakura_bark", "ghostwood_bark", "hopseed_bark", "eucalyptus_heart", "sakura_heart", "ghostwood_heart", "hopseed_heart"};

    public TreeBlock() {
        this.setHardness(1.5f);
        this.setResistance(5.0f);
        this.setStepSound(Block.soundTypeWood);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        int tex = metadata % 4;
        int orientation = metadata / 4;
        switch (orientation) {
            case 0: {
                if (side != 0 && side != 1) break;
                return this.icons[tex + 4];
            }
            case 1: {
                if (side != 4 && side != 5) break;
                return this.icons[tex + 4];
            }
            case 2: {
                if (side != 2 && side != 3) break;
                return this.icons[tex + 4];
            }
        }
        return this.icons[tex];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister IIconRegister2) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = IIconRegister2.registerIcon("natura:" + this.textureNames[i]);
        }
    }

    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return Item.getItemFromBlock((Block)this);
    }

    public int damageDropped(int meta) {
        return meta % 4;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return metadata % 4 != 2 ? this.getFlammability(world, x, y, z, face) : 0;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return metadata % 4 != 2 ? this.getFireSpreadSpeed((IBlockAccess)world, x, y, z, face) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 4; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }
}

