/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import mods.natura.worldgen.RareTreeGen;
import mods.natura.worldgen.WillowGen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class OverworldSapling
extends BlockSapling {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"maple", "silverbell", "purpleheart", "tiger", "willow"};

    public OverworldSapling() {
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setHardness(0.0f);
        this.setStepSound(Block.soundTypeGrass);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:" + this.textureNames[i] + "_sapling");
        }
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        Block blockID = world.getBlock(x, y, z);
        return blockID == Blocks.air || blockID.getMaterial().isReplaceable();
    }

    public boolean canThisPlantGrowOnThisBlock(Block id) {
        return id == Blocks.grass || id == Blocks.dirt || id == Blocks.soul_sand || id == Blocks.netherrack || id == NContent.taintedSoil;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z) % 8;
        switch (meta) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                Block soil = world.getBlock(x, y - 1, z);
                return (world.getFullBlockLightValue(x, y, z) >= 8 || world.canBlockSeeTheSky(x, y, z)) && soil != null && soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
        }
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        if (world.isRemote) {
            return;
        }
        super.updateTick(world, x, y, z, random);
        int md = world.getBlockMetadata(x, y, z);
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && random.nextInt(120) == 0) {
            if ((md & 8) == 0) {
                world.setBlockMetadataWithNotify(x, y, z, md | 8, 4);
            } else {
                this.func_149878_d(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icons[meta % 8 % this.icons.length];
    }

    public void func_149879_c(World p_149879_1_, int p_149879_2_, int p_149879_3_, int p_149879_4_, Random p_149879_5_) {
        int l = p_149879_1_.getBlockMetadata(p_149879_2_, p_149879_3_, p_149879_4_);
        if ((l & 8) == 0) {
            p_149879_1_.setBlockMetadataWithNotify(p_149879_2_, p_149879_3_, p_149879_4_, l | 8, 4);
        } else {
            this.func_149878_d(p_149879_1_, p_149879_2_, p_149879_3_, p_149879_4_, p_149879_5_);
        }
    }

    public void func_149878_d(World world, int x, int y, int z, Random random) {
        int md = world.getBlockMetadata(x, y, z) % 8;
        world.setBlock(x, y, z, Blocks.air);
        WorldGenerator obj = null;
        obj = md == 1 ? new RareTreeGen(true, 4, 2, 1, 1) : (md == 2 ? new RareTreeGen(true, 9, 8, 2, 2) : (md == 3 ? new RareTreeGen(true, 6, 4, 3, 3) : (md == 4 ? new WillowGen(true) : new RareTreeGen(true, 4, 2, 0, 0))));
        if (!obj.generate(world, random, x, y, z)) {
            world.setBlock(x, y, z, (Block)this, md + 8, 3);
        }
    }

    public int damageDropped(int i) {
        return i % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < this.icons.length; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        return true;
    }

    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return (double)p_149852_1_.rand.nextFloat() < 0.45;
    }

    public void func_149853_b(World p_149853_1_, Random p_149853_2_, int p_149853_3_, int p_149853_4_, int p_149853_5_) {
        this.func_149879_c(p_149853_1_, p_149853_3_, p_149853_4_, p_149853_5_, p_149853_2_);
    }
}

