/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.crops;

import java.util.Random;
import mods.natura.blocks.crops.CropBlock;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class HerbBlock
extends CropBlock {
    protected HerbBlock() {
        this.setTickRandomly(true);
        float var3 = 0.5f;
        this.setBlockBounds(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 0.25f, 0.5f + var3);
        this.setCreativeTab(null);
        this.setHardness(0.0f);
        this.setStepSound(soundTypeGrass);
        this.disableStats();
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random random) {
        float grow;
        int meta;
        this.checkAndDropBlock(world, x, y, z);
        int light = world.getBlockLightValue(x, y, z);
        if (light >= 8 && (meta = world.getBlockMetadata(x, y, z)) % 4 != 3 && random.nextInt((int)(50.0f / (grow = this.getGrowthRate(world, x, y, z, meta, light))) + 1) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, ++meta, 2);
        }
    }

    public void fertilize(World world, int x, int y, int z) {
    }

    @Override
    boolean requiresSun(int meta) {
        return false;
    }

    @Override
    public int getRenderType() {
        return 1;
    }

    @Override
    public Item getCropItem(int meta) {
        return NContent.plantItem;
    }

    @Override
    public Item getSeedItem(int meta) {
        return NContent.seeds;
    }

    @Override
    public int damageDropped(int meta) {
        return 0;
    }

    @Override
    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z);
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    @Override
    public boolean canBlockStay(World par1World, int x, int y, int z) {
        Block soil = par1World.getBlock(x, y - 1, z);
        return soil != null && soil.getMaterial() == Material.rock;
    }
}

