/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BushTreeGen
extends WorldGenerator {
    private final int baseHeight;
    private final int woodMetadata;
    private final int leavesMetadata;

    public BushTreeGen(boolean par1, int height, int mdwood, int mdleaves) {
        super(par1);
        this.baseHeight = height;
        this.woodMetadata = mdwood;
        this.leavesMetadata = mdleaves;
    }

    int findGround(World world, int x, int y, int z) {
        boolean foundGround = false;
        int height = PHNatura.seaLevel + 64;
        do {
            Block underID;
            if ((underID = world.func_147439_a(x, --height, z)) != Blocks.field_150346_d && underID != Blocks.field_150349_c && height >= PHNatura.seaLevel) continue;
            foundGround = true;
        } while (!foundGround);
        return height + 1;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int var6 = random.nextInt(3) + this.baseHeight;
        boolean var7 = true;
        if ((y = this.findGround(world, x, y, z)) >= 1 && y + var6 + 1 <= 256) {
            int var10;
            for (int var8 = y; var8 <= y + 1 + var6; ++var8) {
                int var9 = 2;
                if (var8 == y) {
                    var9 = 1;
                }
                if (var8 >= y + 1 + var6 - 2) {
                    var9 = 2;
                }
                for (var10 = x - var9; var10 <= x + var9 && var7; ++var10) {
                    for (int var11 = z - var9; var11 <= z + var9 && var7; ++var11) {
                        if (var8 >= 0 && var8 < 256) {
                            Block block12 = world.func_147439_a(var10, var8, var11);
                            if (this.isReplaceable(world, var10, var8, var11)) continue;
                            var7 = true;
                            continue;
                        }
                        var7 = false;
                    }
                }
            }
            if (!var7) {
                return false;
            }
            Block b8 = world.func_147439_a(x, y - 1, z);
            if ((b8 == Blocks.field_150349_c || b8 == Blocks.field_150346_d) && y < 256 - var6 - 1) {
                this.func_150516_a(world, x, y - 1, z, Blocks.field_150346_d, 0);
                this.func_150516_a(world, x + 1, y - 1, z, Blocks.field_150346_d, 0);
                this.func_150516_a(world, x, y - 1, z + 1, Blocks.field_150346_d, 0);
                this.func_150516_a(world, x + 1, y - 1, z + 1, Blocks.field_150346_d, 0);
                this.growLogs(world, x, y, z);
                this.growLeaves(world, x, z, y + var6, 2, random);
                for (var10 = 0; var10 < var6; ++var10) {
                    b8 = world.func_147439_a(x, y + var10, z);
                    if (b8 == Blocks.field_150350_a || b8 == null || b8.isLeaves((IBlockAccess)world, x, y + var10, z)) {
                        world.func_147465_d(x, y + var10, z, NContent.tree, this.woodMetadata, 0);
                    }
                    if (var10 >= var6 - 1) continue;
                    b8 = world.func_147439_a(x + 1, y + var10, z);
                    if (b8 == Blocks.field_150350_a || b8 == null || b8.isLeaves((IBlockAccess)world, x + 1, y + var10, z)) {
                        world.func_147465_d(x + 1, y + var10, z, NContent.tree, this.woodMetadata, 0);
                    }
                    if ((b8 = world.func_147439_a(x + 1, y + var10, z + 1)) == Blocks.field_150350_a || b8 == null || b8.isLeaves((IBlockAccess)world, x + 1, y + var10, z + 1)) {
                        world.func_147465_d(x + 1, y + var10, z + 1, NContent.tree, this.woodMetadata, 0);
                    }
                    if ((b8 = world.func_147439_a(x, y + var10, z + 1)) != Blocks.field_150350_a && b8 != null && !b8.isLeaves((IBlockAccess)world, x, y + var10, z + 1)) continue;
                    world.func_147465_d(x, y + var10, z + 1, NContent.tree, this.woodMetadata, 0);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void growLeaves(World par1World, int par2, int par3, int par4, int par5, Random par6Random) {
        int var7 = 2;
        for (int var8 = par4 - var7; var8 <= par4; ++var8) {
            int var9 = var8 - par4;
            int var10 = par5 + 1 - var9;
            for (int var11 = par2 - var10; var11 <= par2 + var10 + 1; ++var11) {
                int var12 = var11 - par2;
                for (int var13 = par3 - var10; var13 <= par3 + var10 + 1; ++var13) {
                    int var14 = var13 - par3;
                    Block block = par1World.func_147439_a(var11, var8, var13);
                    if (var12 < 0 && var14 < 0 && var12 * var12 + var14 * var14 > var10 * var10 || (var12 > 0 || var14 > 0) && var12 * var12 + var14 * var14 > (var10 + 1) * (var10 + 1) || par6Random.nextInt(4) == 0 && var12 * var12 + var14 * var14 > (var10 - 1) * (var10 - 1) || block != null && !block.canBeReplacedByLeaves((IBlockAccess)par1World, var11, var8, var13)) continue;
                    this.func_150516_a(par1World, var11, var8, var13, (Block)NContent.floraLeaves, this.leavesMetadata);
                }
            }
        }
    }

    private void growLogs(World world, int x, int y, int z) {
        this.func_150516_a(world, x, y, z, NContent.tree, this.woodMetadata);
        this.func_150516_a(world, x + 1, y, z, NContent.tree, this.woodMetadata);
        this.func_150516_a(world, x, y, z + 1, NContent.tree, this.woodMetadata);
        this.func_150516_a(world, x + 1, y, z + 1, NContent.tree, this.woodMetadata);
        this.func_150516_a(world, x, y + 1, z, NContent.tree, this.woodMetadata);
        this.func_150516_a(world, x + 1, y + 1, z, NContent.tree, this.woodMetadata);
        this.func_150516_a(world, x, y + 1, z + 1, NContent.tree, this.woodMetadata);
        this.func_150516_a(world, x + 1, y + 1, z + 1, NContent.tree, this.woodMetadata);
    }

    protected boolean isReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z) || block.isWood((IBlockAccess)world, x, y, z);
    }
}

