/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.MultiItemBlock;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NSaplingItem
extends MultiItemBlock {
    public static final String[] blockType = new String[]{"redwood", "eucalyptus", "bush", "sakura", "ghost", "blood", "darkwood", "fusewood", "", "", "", "", "", "", "", "", ""};
    private Block bID;

    public NSaplingItem(Block block) {
        super(block, "block.sapling", blockType);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.bID = block;
    }

    public IIcon getIconFromDamage(int i) {
        return NContent.floraSapling.getIcon(0, i);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        switch (stack.getItemDamage()) {
            case 0: {
                list.add(StatCollector.translateToLocal((String)"tooltip.sapling1"));
                list.add(StatCollector.translateToLocal((String)"tooltip.sapling2"));
                break;
            }
            case 1: {
                list.add(StatCollector.translateToLocal((String)"tooltip.tree1"));
                break;
            }
            case 2: {
                list.add(StatCollector.translateToLocal((String)"tooltip.tree6"));
                break;
            }
            case 3: {
                list.add(StatCollector.translateToLocal((String)"tooltip.tree2"));
                break;
            }
            case 4: {
                list.add(StatCollector.translateToLocal((String)"tooltip.tree3"));
                break;
            }
            case 5: {
                list.add(StatCollector.translateToLocal((String)"tooltip.sapling3"));
                list.add(StatCollector.translateToLocal((String)"tooltip.sapling4"));
                break;
            }
            case 6: {
                list.add(StatCollector.translateToLocal((String)"tooltip.sapling5"));
                break;
            }
            case 7: {
                list.add(StatCollector.translateToLocal((String)"tooltip.fusewood.log"));
            }
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        Block block;
        Block blockID = world.getBlock(x, y, z);
        if (blockID == Blocks.snow && (world.getBlockMetadata(x, y, z) & 7) < 1) {
            side = 1;
        } else if (!(blockID == Blocks.vine || blockID == Blocks.tallgrass || blockID == Blocks.deadbush || blockID != null && blockID.isReplaceable((IBlockAccess)world, x, y, z))) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (stack.getItemDamage() == 5 ? (block = world.getBlock(x, y + 1, z)) == null || world.isAirBlock(x, y + 1, z) : (block = world.getBlock(x, y - 1, z)) == null || world.isAirBlock(x, y - 1, z)) {
            return false;
        }
        if (stack.stackSize == 0) {
            return false;
        }
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        if (y == 255 && this.bID.getMaterial().isSolid()) {
            return false;
        }
        if (world.canPlaceEntityOnSide(this.bID, x, y, z, false, side, (Entity)player, stack)) {
            block = this.bID;
            int j1 = this.getMetadata(stack.getItemDamage());
            int k1 = this.bID.onBlockPlaced(world, x, y, z, side, par8, par9, par10, j1);
            if (this.placeBlockAt(stack, player, world, x, y, z, side, par8, par9, par10, k1)) {
                world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.stepSound.getBreakSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                --stack.stackSize;
            }
            return true;
        }
        return false;
    }
}

