/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;

public class NitroCreeper
extends EntityCreeper {
    protected int fuseTime = 12;
    protected int timeSinceIgnited;
    protected int lastActiveTime;
    public float explosionRadius = 1.0f;

    public NitroCreeper(World world) {
        super(world);
        this.tasks.addTask(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.isImmuneToFire = true;
    }

    protected void fall(float distance) {
        if (!this.worldObj.isRemote) {
            if (distance > 5.0f) {
                boolean flag = this.worldObj.getGameRules().getGameRuleBooleanValue("mobGriefing");
                if (this.getPowered()) {
                    this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 20.0f, flag);
                } else {
                    this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 3.0f, false);
                }
                this.setDead();
            } else {
                super.fall(distance);
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setShort("Fuse", (short)this.fuseTime);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasKey("Fuse")) {
            this.fuseTime = par1NBTTagCompound.getShort("Fuse");
        }
    }

    public void onUpdate() {
        if (this.isEntityAlive()) {
            int powered;
            this.lastActiveTime = this.timeSinceIgnited;
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.playSound("random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            int difficulty = this.worldObj.difficultySetting.getDifficultyId();
            int lengthBoost = 4 * (3 - difficulty);
            int n = powered = this.getPowered() ? 12 : 0;
            if (this.timeSinceIgnited >= this.fuseTime + difficulty + powered) {
                this.timeSinceIgnited = this.fuseTime;
                if (!this.worldObj.isRemote) {
                    boolean flag = this.worldObj.getGameRules().getGameRuleBooleanValue("mobGriefing");
                    if (powered > 0) {
                        this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 20.0f, flag);
                    } else {
                        this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 3.0f, flag);
                    }
                    this.setDead();
                }
            }
        }
        super.onUpdate();
    }

    public float getCreeperFlashIntensity(float par1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * par1) / (float)(this.fuseTime - 2);
    }

    protected void dropFewItems(boolean par1, int par2) {
        int l;
        int k;
        Item j = this.getDropItem();
        if (j != null) {
            k = this.rand.nextInt(4) + 2;
            if (par2 > 0) {
                k += this.rand.nextInt(par2 + 1);
            }
            for (l = 0; l < k; ++l) {
                this.dropItem(j, 1);
            }
        }
        if (this.getPowered() && j != null) {
            k = this.rand.nextInt(40) + 20;
            if (par2 > 0) {
                k += this.rand.nextInt(par2 * 6 + 1);
            }
            for (l = 0; l < k; ++l) {
                this.dropItem(j, 1);
            }
        }
    }

    public boolean attackEntityFrom(DamageSource source, int damage) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).getEntity() instanceof EntityIronGolem) {
            damage = 1000;
        }
        return super.attackEntityFrom(source, (float)damage);
    }
}

