/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.recipes;

import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

public class IronShulkerBoxesColoringRecipe
extends CustomRecipe {
    public IronShulkerBoxesColoringRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingContainer pInv, Level pLevel) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < pInv.getContainerSize(); ++k) {
            ItemStack itemstack = pInv.getItem(k);
            if (itemstack.isEmpty()) continue;
            if (Block.byItem((Item)itemstack.getItem()) instanceof AbstractIronShulkerBoxBlock) {
                ++i;
            } else {
                if (!itemstack.is(Tags.Items.DYES)) {
                    return false;
                }
                ++j;
            }
            if (j <= 1 && i <= 1) continue;
            return false;
        }
        return i == 1 && j == 1;
    }

    public ItemStack assemble(CraftingContainer pInv, RegistryAccess registryAccess) {
        ItemStack itemStack = ItemStack.EMPTY;
        DyeColor dyeColor = DyeColor.WHITE;
        for (int i = 0; i < pInv.getContainerSize(); ++i) {
            ItemStack itemStackInInv = pInv.getItem(i);
            if (itemStackInInv.isEmpty()) continue;
            Item item = itemStackInInv.getItem();
            if (Block.byItem((Item)item) instanceof AbstractIronShulkerBoxBlock) {
                itemStack = itemStackInInv;
                continue;
            }
            DyeColor tmp = DyeColor.getColor((ItemStack)itemStackInInv);
            if (tmp == null) continue;
            dyeColor = tmp;
        }
        ItemStack newItemStack = AbstractIronShulkerBoxBlock.getColoredItemStack(dyeColor, AbstractIronShulkerBoxBlock.getTypeFromItem(itemStack.getItem()));
        if (itemStack.hasTag() && itemStack.getTag() != null) {
            newItemStack.setTag(itemStack.getTag().copy());
        }
        return newItemStack;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)IronShulkerBoxesRecipes.SHULKER_BOX_COLORING.get();
    }
}

