/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.item;

import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlockEntityTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class IronShulkerBoxItemStackInvWrapper
implements IItemHandlerModifiable {
    private final ItemStack stack;
    private final IronShulkerBoxesTypes type;
    private CompoundTag cachedTag;
    private NonNullList<ItemStack> itemStacksCache;

    public IronShulkerBoxItemStackInvWrapper(ItemStack stack, IronShulkerBoxesTypes type) {
        this.stack = stack;
        this.type = type;
    }

    public int getSlots() {
        return this.type.size;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.getItemList().get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        int limit = Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
        if (!existing.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                itemStacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.setItemList(itemStacks);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - limit)) : ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                itemStacks.set(slot, (Object)ItemStack.EMPTY);
                this.setItemList(itemStacks);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            itemStacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.getCount() - toExtract)));
            this.setItemList(itemStacks);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + stack + " for slot " + slot + ")");
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    private NonNullList<ItemStack> getItemList() {
        CompoundTag rootTag = BlockItem.getBlockEntityData((ItemStack)this.stack);
        if (this.cachedTag == null || !this.cachedTag.equals((Object)rootTag)) {
            this.itemStacksCache = this.refreshItemList(rootTag);
        }
        return this.itemStacksCache;
    }

    private NonNullList<ItemStack> refreshItemList(CompoundTag rootTag) {
        NonNullList itemStacks = NonNullList.withSize((int)this.getSlots(), (Object)ItemStack.EMPTY);
        if (rootTag != null && rootTag.contains("Items", 9)) {
            ContainerHelper.loadAllItems((CompoundTag)rootTag, (NonNullList)itemStacks);
        }
        this.cachedTag = rootTag;
        return itemStacks;
    }

    private void setItemList(NonNullList<ItemStack> itemStacks) {
        CompoundTag existing = BlockItem.getBlockEntityData((ItemStack)this.stack);
        CompoundTag rootTag = ContainerHelper.saveAllItems((CompoundTag)(existing == null ? new CompoundTag() : existing), itemStacks);
        switch (this.type) {
            case IRON: {
                BlockItem.setBlockEntityData((ItemStack)this.stack, (BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.IRON_SHULKER_BOX.get()), (CompoundTag)rootTag);
                break;
            }
            case GOLD: {
                BlockItem.setBlockEntityData((ItemStack)this.stack, (BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.GOLD_SHULKER_BOX.get()), (CompoundTag)rootTag);
                break;
            }
            case DIAMOND: {
                BlockItem.setBlockEntityData((ItemStack)this.stack, (BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.DIAMOND_SHULKER_BOX.get()), (CompoundTag)rootTag);
                break;
            }
            case COPPER: {
                BlockItem.setBlockEntityData((ItemStack)this.stack, (BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.COPPER_SHULKER_BOX.get()), (CompoundTag)rootTag);
                break;
            }
            case CRYSTAL: {
                BlockItem.setBlockEntityData((ItemStack)this.stack, (BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.CRYSTAL_SHULKER_BOX.get()), (CompoundTag)rootTag);
                break;
            }
            case OBSIDIAN: {
                BlockItem.setBlockEntityData((ItemStack)this.stack, (BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.OBSIDIAN_SHULKER_BOX.get()), (CompoundTag)rootTag);
            }
        }
        this.cachedTag = rootTag;
    }
}

