/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.data.loot;

import com.google.common.collect.ImmutableSet;
import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlockEntityTypes;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public class IronShulkerBoxesBlockLoot
extends BlockLootSubProvider {
    private static final Set<Item> EXPLOSION_RESISTANT = IronShulkerBoxesBlockLoot.getExplosionResistance().stream().map(ItemLike::asItem).collect(Collectors.toSet());
    private final Set<Block> knownBlocks = new ReferenceOpenHashSet();

    public IronShulkerBoxesBlockLoot() {
        super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags());
    }

    protected void generate() {
        this.add((Block)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.IRON_SHULKER_BOX.get())));
        this.add((Block)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.GOLD_SHULKER_BOX.get())));
        this.add((Block)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.DIAMOND_SHULKER_BOX.get())));
        this.add((Block)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.COPPER_SHULKER_BOX.get())));
        this.add((Block)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.CRYSTAL_SHULKER_BOX.get())));
        this.add((Block)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.OBSIDIAN_SHULKER_BOX.get())));
        for (DyeColor color : DyeColor.values()) {
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.IRON_SHULKER_BOX.get())));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.GOLD_SHULKER_BOX.get())));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.DIAMOND_SHULKER_BOX.get())));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.COPPER_SHULKER_BOX.get())));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.CRYSTAL_SHULKER_BOX.get())));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get(), block -> this.createShulkerBoxDrop((Block)block, (BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.OBSIDIAN_SHULKER_BOX.get())));
        }
    }

    protected void add(@NotNull Block block, @NotNull LootTable.Builder table) {
        super.add(block, table);
        this.knownBlocks.add(block);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected LootTable.Builder createShulkerBoxDrop(Block pBlock, BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity> blockEntityType) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)pBlock, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pBlock).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Lock", "BlockEntityTag.Lock").copy("LootTable", "BlockEntityTag.LootTable").copy("LootTableSeed", "BlockEntityTag.LootTableSeed")).apply((LootItemFunction.Builder)SetContainerContents.setContents(blockEntityType).withEntry((LootPoolEntryContainer.Builder)DynamicLoot.dynamicEntry((ResourceLocation)AbstractIronShulkerBoxBlock.CONTENTS))))));
    }

    protected static Set<Block> getExplosionResistance() {
        ImmutableSet.Builder blocks = new ImmutableSet.Builder();
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get()));
        IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        return blocks.build();
    }
}

