/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.blocks.logic.SignalTerminalLogic;
import tmechworks.client.block.SignalTerminalRender;
import tmechworks.common.MechContent;
import tmechworks.lib.TMechworksRegistry;

public class SignalTerminal
extends Block
implements ITileEntityProvider {
    public static int HITBOXES = 13;
    public static int[] sideBoxMapping = new int[]{-1, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
    public IIcon[] icons;
    public IIcon[] channelIcons;
    public String[] textureNames = new String[]{"signalbus"};
    public String[] channelTextureNames = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "lightgray", "cyan", "purple", "blue", "brown", "green", "red", "black"};

    public SignalTerminal() {
        super(Material.circuits);
        this.setHardness(0.1f);
        this.setResistance(1.0f);
        this.setStepSound(soundTypeMetal);
        this.setCreativeTab(TMechworksRegistry.Mechworks);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        return this.icons[0];
    }

    public IIcon getChannelIcon(int channel) {
        if (channel < 0 || channel >= this.channelIcons.length) {
            return this.channelIcons[0];
        }
        return this.channelIcons[channel];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        int i;
        this.icons = new IIcon[this.textureNames.length];
        for (i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("tmechworks:" + this.textureNames[i]);
        }
        this.channelIcons = new IIcon[this.channelTextureNames.length];
        for (i = 0; i < this.channelIcons.length; ++i) {
            this.channelIcons[i] = iconRegister.registerIcon("tmechworks:glass/stainedglass_" + this.channelTextureNames[i]);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.getTileEntity(x, y, z);
        return te != null && te instanceof SignalTerminalLogic && ((SignalTerminalLogic)te).getConnectedSides()[side.ordinal()] != -1;
    }

    public int getRenderType() {
        return SignalTerminalRender.renderID;
    }

    public int tickRate(World par1World) {
        return 1;
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        float minX = 1.0f;
        float minY = 1.0f;
        float minZ = 1.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float maxZ = 0.0f;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            for (AxisAlignedBB aabb : SignalTerminal.getBoxes((SignalTerminalLogic)te)) {
                if (aabb == null) continue;
                minX = Math.min(minX, (float)aabb.minX);
                minY = Math.min(minY, (float)aabb.minY);
                minZ = Math.min(minZ, (float)aabb.minZ);
                maxX = Math.max(maxX, (float)aabb.maxX);
                maxY = Math.max(maxY, (float)aabb.maxY);
                maxZ = Math.max(maxZ, (float)aabb.maxZ);
            }
            this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
        } else {
            this.setBlockBounds(0.375f, 0.375f, 0.375f, 0.625f, 0.625f, 0.625f);
        }
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN);
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB collisionTest, List collisionBoxList, Entity entity) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            for (AxisAlignedBB aabb : SignalTerminal.getBoxes((SignalTerminalLogic)te)) {
                if (aabb == null) continue;
                aabb = AxisAlignedBB.getBoundingBox((double)aabb.minX, (double)aabb.minY, (double)aabb.minZ, (double)aabb.maxX, (double)aabb.maxY, (double)aabb.maxZ);
                aabb.minX += (double)x;
                aabb.minY += (double)y;
                aabb.minZ += (double)z;
                aabb.maxX += (double)x;
                aabb.maxY += (double)y;
                aabb.maxZ += (double)z;
                if (!collisionTest.intersectsWith(aabb)) continue;
                collisionBoxList.add(aabb);
            }
        } else {
            super.addCollisionBoxesToList(world, x, y, z, collisionTest, collisionBoxList, entity);
        }
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int localSide) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            return ((SignalTerminalLogic)te).isProvidingWeakPower(localSide);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public int isProvidingStrongPower(IBlockAccess world, int x, int y, int z, int localSide) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            return ((SignalTerminalLogic)te).isProvidingStrongPower(localSide);
        }
        return 0;
    }

    public boolean canProvidePower() {
        return true;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new SignalTerminalLogic();
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborID) {
        super.onNeighborBlockChange(world, x, y, z, neighborID);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            ((SignalTerminalLogic)te).onNeighborBlockChange();
        }
    }

    private static AxisAlignedBB[] getBoxes(SignalTerminalLogic logic) {
        byte[] connected = logic.getConnectedSides();
        AxisAlignedBB[] parts = new AxisAlignedBB[HITBOXES];
        parts[0] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.center_min, (double)TerminalGeometry.center_min, (double)TerminalGeometry.center_min, (double)TerminalGeometry.center_max, (double)TerminalGeometry.center_max, (double)TerminalGeometry.center_max);
        if (connected[ForgeDirection.DOWN.ordinal()] != -1) {
            parts[1] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_low_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_low_max, (double)TerminalGeometry.plate_width_max);
            parts[2] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_low_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_low_max, (double)TerminalGeometry.channel_width_max);
        }
        if (connected[ForgeDirection.UP.ordinal()] != -1) {
            parts[3] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_high_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_high_max, (double)TerminalGeometry.plate_width_max);
            parts[4] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_high_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_high_max, (double)TerminalGeometry.channel_width_max);
        }
        if (connected[ForgeDirection.NORTH.ordinal()] != -1) {
            parts[5] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_high_min, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_high_max);
            parts[6] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_high_min, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_high_max);
        }
        if (connected[ForgeDirection.SOUTH.ordinal()] != -1) {
            parts[7] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_low_min, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_low_max);
            parts[8] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_low_min, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_low_max);
        }
        if (connected[ForgeDirection.WEST.ordinal()] != -1) {
            parts[9] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.plate_low_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_low_max, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_width_max);
            parts[10] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.channel_low_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_low_max, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_width_max);
        }
        if (connected[ForgeDirection.EAST.ordinal()] != -1) {
            parts[11] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.plate_high_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_high_max, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_width_max);
            parts[12] = AxisAlignedBB.getBoundingBox((double)TerminalGeometry.channel_high_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_high_max, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_width_max);
        }
        return parts;
    }

    private static int closestClicked(EntityPlayer player, double reachDistance, SignalTerminalLogic terminal, AxisAlignedBB[] parts) {
        int closest = -1;
        Vec3 playerPosition = Vec3.createVectorHelper((double)(player.posX - (double)terminal.xCoord), (double)(player.posY - (double)terminal.yCoord + (double)player.getEyeHeight()), (double)(player.posZ - (double)terminal.zCoord));
        Vec3 playerLook = player.getLookVec();
        Vec3 playerViewOffset = Vec3.createVectorHelper((double)(playerPosition.xCoord + playerLook.xCoord * reachDistance), (double)(playerPosition.yCoord + playerLook.yCoord * reachDistance), (double)(playerPosition.zCoord + playerLook.zCoord * reachDistance));
        double closestCalc = Double.MAX_VALUE;
        double hitDistance = 0.0;
        for (int i = 0; i < parts.length; ++i) {
            MovingObjectPosition hit;
            if (parts[i] == null || (hit = parts[i].calculateIntercept(playerPosition, playerViewOffset)) == null || !((hitDistance = playerPosition.distanceTo(hit.hitVec)) < closestCalc)) continue;
            closestCalc = hitDistance;
            closest = i;
        }
        return closest;
    }

    public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileEntity te = par1World.getTileEntity(par2, par3, par4);
        if (!par1World.isRemote && te != null && te instanceof SignalTerminalLogic) {
            int boxHit;
            if (!par1World.isRemote) {
                par1World.markBlockForUpdate(par2, par3, par4);
            }
            if ((boxHit = SignalTerminal.closestClicked(par5EntityPlayer, 3.0, (SignalTerminalLogic)te, SignalTerminal.getBoxes((SignalTerminalLogic)te))) < 0 || boxHit >= HITBOXES) {
                return false;
            }
            if (boxHit == 0) {
                return false;
            }
            int side = sideBoxMapping[boxHit];
            if (side < 0 || side >= 6) {
                return false;
            }
            if (par5EntityPlayer.isSneaking()) {
                ((SignalTerminalLogic)te).prevChannel(side);
            } else {
                ((SignalTerminalLogic)te).nextChannel(side);
            }
        }
        return false;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            NBTTagCompound data = itemStack.stackTagCompound;
            if (data != null && data.hasKey("connectedSide")) {
                ((SignalTerminalLogic)te).addPendingSide(data.getInteger("connectedSide"));
                itemStack.stackTagCompound = null;
            }
            ((SignalTerminalLogic)te).connectPending();
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void breakBlock(World world, int x, int y, int z, Block id, int meta) {
        int dropWire = 0;
        Random rand = new Random();
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            float offset;
            EntityItem entityitem;
            float jumpZ;
            float jumpY;
            float jumpX;
            ItemStack tempStack;
            int dropTerm = ((SignalTerminalLogic)te).getDroppedTerminals();
            dropWire = ((SignalTerminalLogic)te).getDroppedWire();
            if (dropTerm > 0) {
                tempStack = new ItemStack(MechContent.signalTerminal, dropTerm, 0);
                jumpX = rand.nextFloat() * 0.8f + 0.1f;
                jumpY = rand.nextFloat() * 0.8f + 0.1f;
                jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                offset = 0.05f;
                entityitem.motionX = (float)rand.nextGaussian() * offset;
                entityitem.motionY = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.motionZ = (float)rand.nextGaussian() * offset;
                world.spawnEntityInWorld((Entity)entityitem);
            }
            if (dropWire > 0) {
                tempStack = new ItemStack(MechContent.lengthWire, dropWire);
                jumpX = rand.nextFloat() * 0.8f + 0.1f;
                jumpY = rand.nextFloat() * 0.8f + 0.1f;
                jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                offset = 0.05f;
                entityitem.motionX = (float)rand.nextGaussian() * offset;
                entityitem.motionY = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.motionZ = (float)rand.nextGaussian() * offset;
                world.spawnEntityInWorld((Entity)entityitem);
            }
            ((SignalTerminalLogic)te).notifyBreak();
        }
        super.breakBlock(world, x, y, z, id, meta);
    }

    public static class TerminalGeometry {
        public static float plate_width_min = 0.25f;
        public static float plate_width_max = 0.75f;
        public static float plate_low_max = 0.15f;
        public static float plate_high_max = 1.0f;
        public static float plate_low_min = 0.0f;
        public static float plate_high_min = 1.0f - plate_low_max;
        public static float center_min = 0.375f;
        public static float center_max = 0.625f;
        public static float channel_width_min = 0.375f;
        public static float channel_width_max = 0.625f;
        public static float channel_low_max = center_min;
        public static float channel_high_max = plate_high_min;
        public static float channel_low_min = plate_low_max;
        public static float channel_high_min = center_max;
    }
}

