/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.IEntitySelector;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import tmechworks.blocks.logic.SubFilter;
import tmechworks.client.block.FilterRender;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.blocks.IBlockWithMetadata;

public class FilterBlock
extends Block
implements IBlockWithMetadata {
    public static final double thickness = 0.1875;
    public static final double sideWidth = 0.2;
    public SubFilter[] subFilters = new SubFilter[8];
    protected IIcon[] subMeshIcons = new IIcon[8];
    protected static int ticksPerUpdate = 10;
    public static final double hackHeight = 0.05;

    public FilterBlock() {
        super(Material.iron);
        this.setCreativeTab(TMechworksRegistry.Mechworks);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
        this.setHardness(3.0f);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        return true;
    }

    public int getRenderType() {
        return FilterRender.renderID;
    }

    public IIcon getMeshIcon(int metadata) {
        if (this.subMeshIcons[metadata & 7] != null) {
            return this.subMeshIcons[metadata & 7];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        super.registerBlockIcons(iconRegister);
        for (int i = 1; i < 8; ++i) {
            if (this.subFilters[i] == null || this.subFilters[i].getMeshIconName() == null) continue;
            this.subMeshIcons[i] = iconRegister.registerIcon(this.subFilters[i].getMeshIconName());
        }
    }

    public void setSubFilter(SubFilter setTo, int i) {
        if (i != 0 && i < 8) {
            this.subFilters[i] = setTo;
        }
    }

    public int getSubFilter(IBlockAccess world, CoordTuple position) {
        return this.getSubFilter(world.getBlockMetadata(position.x, position.y, position.z));
    }

    public int getSubFilter(int metadata) {
        return metadata & 7;
    }

    public boolean isTop(IBlockAccess world, CoordTuple position) {
        return (world.getBlockMetadata(position.x, position.y, position.z) & 8) != 0;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        if (this.isTop(world, new CoordTuple((double)x, (double)y, (double)z))) {
            this.setBlockBounds(0.0f, 0.8125f, 0.0f, 1.0f, 0.95f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
        }
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB region, List result, Entity entity) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        super.addCollisionBoxesToList(world, x, y, z, region, result, entity);
    }

    private final AxisAlignedBB getOffsetAABB(double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        return AxisAlignedBB.getBoundingBox((double)(x + x1), (double)(y + y1), (double)(z + z1), (double)(x + x2), (double)(y + y2), (double)(z + z2));
    }

    public int onBlockPlaced(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        return par5 != 0 && (par5 == 1 || (double)par7 <= 0.5) ? par9 : par9 | 8;
    }

    public int damageDropped(int meta) {
        return meta & 7;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean filter_shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        if (side != 1 && side != 0 && !super.shouldSideBeRendered(world, x, y, z, side)) {
            return false;
        }
        CoordTuple position = new CoordTuple((double)x, (double)y, (double)z);
        boolean flag = this.isTop(world, position);
        if (flag && side == 1) {
            return super.shouldSideBeRendered(world, position.x, position.y, position.z, side);
        }
        if (!flag && side == 0) {
            return super.shouldSideBeRendered(world, position.x, position.y, position.z, side);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int getDamageValue(World par1World, int par2, int par3, int par4) {
        return super.getDamageValue(par1World, par2, par3, par4) & 7;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item ourItem, CreativeTabs tab, List list) {
        list.add(new ItemStack(ourItem, 1, 0));
        for (int i = 1; i < 8; ++i) {
            if (this.subFilters[i] == null) continue;
            list.add(new ItemStack(ourItem, 1, i));
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        block11: {
            boolean setEmpty;
            CoordTuple position;
            block13: {
                ItemStack playerItem;
                block12: {
                    if (world.isRemote) {
                        return !player.isSneaking();
                    }
                    if (player.isSneaking()) break block11;
                    position = new CoordTuple((double)x, (double)y, (double)z);
                    int metadata = world.getBlockMetadata(x, y, z);
                    setEmpty = false;
                    playerItem = player.inventory.getCurrentItem();
                    if (this.subFilters[metadata & 7] == null) break block12;
                    if (this.subFilters[this.getSubFilter(metadata)].getAssociatedItem() == null) break block13;
                    ItemStack item = this.subFilters[this.getSubFilter(metadata)].getAssociatedItem().copy();
                    EntityItem entityitem = new EntityItem(world, player.posX, player.posY - 1.0, player.posZ, item);
                    world.spawnEntityInWorld((Entity)entityitem);
                    if (!(player instanceof FakePlayer)) {
                        entityitem.onCollideWithPlayer(player);
                    }
                    setEmpty = true;
                    break block13;
                }
                if (playerItem != null) {
                    for (int i = 1; i < 8; ++i) {
                        if (this.subFilters[i] == null || this.subFilters[i].getAssociatedItem() == null || this.subFilters[i].getAssociatedItem().getItem() == null || playerItem.getItem() == null || this.subFilters[i].getAssociatedItem().getItem() != playerItem.getItem()) continue;
                        if (this.isTop((IBlockAccess)world, position)) {
                            world.setBlockMetadataWithNotify(position.x, position.y, position.z, i | 8, 3);
                        } else {
                            world.setBlockMetadataWithNotify(position.x, position.y, position.z, i, 3);
                        }
                        if (!player.capabilities.isCreativeMode) {
                            --playerItem.stackSize;
                            if (playerItem.stackSize == 0) {
                                playerItem = null;
                            }
                        }
                        setEmpty = false;
                        break;
                    }
                }
            }
            if (setEmpty) {
                if (this.isTop((IBlockAccess)world, position)) {
                    world.setBlockMetadataWithNotify(position.x, position.y, position.z, 8, 3);
                } else {
                    world.setBlockMetadataWithNotify(position.x, position.y, position.z, 0, 3);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getUnlocalizedNameByMetadata(int damageValue) {
        if (this.subFilters[this.getSubFilter(damageValue)] != null) {
            return this.getUnlocalizedName() + "." + this.subFilters[this.getSubFilter(damageValue)].getSuffix();
        }
        return this.getUnlocalizedName();
    }

    @Override
    public int getItemCount() {
        return 8;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity par5Entity) {
        super.onEntityCollidedWithBlock(world, x, y, z, par5Entity);
        this.doFilterLogic(world, new CoordTuple((double)x, (double)y, (double)z));
    }

    public void doFilterLogic(World worldObj, CoordTuple position) {
        block10: {
            EntityItem entity;
            List list;
            boolean passable;
            int metadata;
            block11: {
                if (worldObj.getTotalWorldTime() % (long)ticksPerUpdate != 0L) break block10;
                metadata = worldObj.getBlockMetadata(position.x, position.y, position.z);
                passable = false;
                if (worldObj.getBlock(position.x, position.y, position.z) == null) {
                    passable = true;
                } else if (!worldObj.getBlock(position.x, position.y - 1, position.z).isNormalCube()) {
                    passable = true;
                }
                IInventory inv = FilterBlock.getInventoryAtLocation(worldObj, position);
                if (inv != null && !this.isTop((IBlockAccess)worldObj, position)) {
                    list = FilterBlock.getEntitiesIn(worldObj, position);
                    for (Object item : list) {
                        if (!(item instanceof EntityItem)) continue;
                        entity = (EntityItem)item;
                        if (this.subFilters[this.getSubFilter(metadata)] == null || !this.subFilters[this.getSubFilter(metadata)].canPass((Entity)entity) || worldObj.isRemote) continue;
                        FilterBlock.insertStackFromEntity(inv, entity);
                    }
                }
                if ((inv = FilterBlock.getInventoryAtLocation(worldObj, position)) == null) break block11;
                if (!this.isTop((IBlockAccess)worldObj, position)) break block10;
                for (int i = 0; i < inv.getSizeInventory(); ++i) {
                    ItemStack itemStack = inv.getStackInSlot(i);
                    if (itemStack == null || this.subFilters[this.getSubFilter(metadata)] == null || !this.subFilters[this.getSubFilter(metadata)].canPass(itemStack) || worldObj.isRemote) continue;
                    ItemStack resultStack = inv.decrStackSize(i, itemStack.stackSize);
                    EntityItem entityItem = new EntityItem(worldObj, (double)position.x + 0.5, (double)position.y + (0.5 - 0.1875), (double)position.z + 0.5);
                    entityItem.setEntityItemStack(resultStack);
                    worldObj.spawnEntityInWorld((Entity)entityItem);
                    entityItem.motionX = 0.0;
                    entityItem.motionY = -entityItem.motionY;
                    entityItem.motionZ = 0.0;
                }
                break block10;
            }
            if (passable) {
                list = null;
                list = this.isTop((IBlockAccess)worldObj, position) ? FilterBlock.getEntitiesIn(worldObj, position.x, position.y + 1, position.z) : FilterBlock.getEntitiesIn(worldObj, position);
                if (list != null) {
                    for (Object item : list) {
                        if (!(item instanceof Entity)) continue;
                        entity = (Entity)item;
                        if (this.subFilters[this.getSubFilter(metadata)] == null || !this.subFilters[this.getSubFilter(metadata)].canPass((Entity)entity)) continue;
                        entity.motionX = 0.0;
                        entity.motionZ = 0.0;
                        if (this.isTop((IBlockAccess)worldObj, position)) {
                            entity.setPosition(entity.posX, (double)position.y + (0.5 - 0.1875), entity.posZ);
                            continue;
                        }
                        entity.setPosition(entity.posX, (double)position.y - ((double)entity.height + 0.1), entity.posZ);
                    }
                }
            }
        }
    }

    public static List getEntitiesIn(World world, CoordTuple pos) {
        return FilterBlock.getEntitiesIn(world, pos.x, pos.y, pos.z);
    }

    protected static List getEntitiesIn(World world, int x, int y, int z) {
        return world.selectEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0)), IEntitySelector.selectAnything);
    }

    public static IInventory getInventoryAtLocation(World world, CoordTuple position) {
        TileEntity tileentity = world.getTileEntity(position.x, position.y, position.z);
        if (tileentity != null && tileentity instanceof IInventory) {
            return (IInventory)tileentity;
        }
        return null;
    }

    public static boolean insertStackFromEntity(IInventory inv, EntityItem entity) {
        boolean flag = false;
        if (entity != null) {
            ItemStack itemstack = entity.getEntityItem().copy();
            ItemStack itemstack1 = FilterBlock.insertStack(inv, itemstack);
            if (itemstack1 != null && itemstack1.stackSize != 0) {
                entity.setEntityItemStack(itemstack1);
            } else {
                flag = true;
                entity.setDead();
            }
        }
        return flag;
    }

    public static ItemStack insertStack(IInventory inv, ItemStack itemStack) {
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack slotStack = inv.getStackInSlot(i);
            int remainingSpace = inv.getInventoryStackLimit();
            if (slotStack != null) {
                remainingSpace -= slotStack.stackSize;
            }
            if (remainingSpace >= itemStack.stackSize) {
                if (slotStack != null) {
                    if (!slotStack.isItemEqual(itemStack)) continue;
                    slotStack.stackSize += itemStack.stackSize;
                    inv.setInventorySlotContents(i, slotStack);
                    return null;
                }
                if (!inv.isItemValidForSlot(i, itemStack)) continue;
                inv.setInventorySlotContents(i, itemStack);
                return null;
            }
            if (slotStack != null) {
                if (!slotStack.isItemEqual(itemStack)) continue;
                slotStack.stackSize += remainingSpace;
                itemStack.stackSize -= remainingSpace;
                inv.setInventorySlotContents(i, slotStack);
                continue;
            }
            if (!inv.isItemValidForSlot(i, itemStack)) continue;
            inv.setInventorySlotContents(i, itemStack.splitStack(remainingSpace));
        }
        return itemStack;
    }
}

