/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.items.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.blocks.logic.SignalTerminalLogic;

public class SignalTerminalItem
extends ItemBlock {
    public static final String[] blockType = new String[]{"signalterminal"};

    public SignalTerminalItem(Block b) {
        super(b);
        this.maxStackSize = 64;
        this.setHasSubtypes(false);
    }

    public int getMetadata(int meta) {
        return meta;
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        int pos = MathHelper.clamp_int((int)itemstack.getItemDamage(), (int)0, (int)(blockType.length - 1));
        return "tile." + blockType[pos];
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer entityPlayer, ItemStack itemStack) {
        return super.func_150936_a(world, x, y, z, side, entityPlayer, itemStack) || this._canPlaceItemBlockOnSide(world, x, y, z, side);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NBTTagCompound data;
        int tmpX = x;
        int tmpY = y;
        int tmpZ = z;
        switch (side) {
            case 0: {
                --tmpY;
                break;
            }
            case 1: {
                ++tmpY;
                break;
            }
            case 2: {
                --tmpZ;
                break;
            }
            case 3: {
                ++tmpZ;
                break;
            }
            case 4: {
                --tmpX;
                break;
            }
            case 5: {
                ++tmpX;
                break;
            }
        }
        int tside = side;
        switch (side) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                tside = ForgeDirection.OPPOSITES[side];
                break;
            }
            default: {
                tside = side;
            }
        }
        stack.stackTagCompound = data = new NBTTagCompound();
        data.setInteger("connectedSide", tside);
        if (super.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!this._canPlaceItemBlockOnSide(world, x, y, z, side)) {
            return false;
        }
        TileEntity te = world.getTileEntity(tmpX, tmpY, tmpZ);
        ((SignalTerminalLogic)te).addPendingSide(tside);
        ((SignalTerminalLogic)te).connectPending();
        stack.stackTagCompound = null;
        --stack.stackSize;
        world.func_147479_m(x, y, z);
        return true;
    }

    private boolean _canPlaceItemBlockOnSide(World world, int x, int y, int z, int side) {
        int tmpX = x;
        int tmpY = y;
        int tmpZ = z;
        switch (side) {
            case 0: {
                --tmpY;
                break;
            }
            case 1: {
                ++tmpY;
                break;
            }
            case 2: {
                --tmpZ;
                break;
            }
            case 3: {
                ++tmpZ;
                break;
            }
            case 4: {
                --tmpX;
                break;
            }
            case 5: {
                ++tmpX;
                break;
            }
        }
        if (world.getBlock(tmpX, tmpY, tmpZ) == this.field_150939_a) {
            TileEntity te = world.getTileEntity(tmpX, tmpY, tmpZ);
            return te != null && te instanceof SignalTerminalLogic;
        }
        return false;
    }
}

