/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tmechworks.TMechworks;
import tmechworks.blocks.logic.DrawbridgeLogic;
import tmechworks.client.gui.DrawbridgeButton;
import tmechworks.network.packet.PacketDrawbridge;

public class DrawbridgeGui
extends GuiContainer {
    public DrawbridgeLogic logic;
    private static final ResourceLocation background = new ResourceLocation("tmechworks", "textures/gui/drawbridge.png");

    public DrawbridgeGui(InventoryPlayer inventoryplayer, DrawbridgeLogic frypan, World world, int x, int y, int z) {
        super(frypan.getGuiContainer(inventoryplayer, world, x, y, z));
        this.logic = frypan;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.drawbridge"), 8, 6, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(background);
        int cornerX = (this.width - this.xSize) / 2;
        int cornerY = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(cornerX, cornerY, 0, 0, this.xSize, this.ySize);
    }

    public void initGui() {
        super.initGui();
        int cornerX = (this.width - this.xSize) / 2;
        int cornerY = (this.height - this.ySize) / 2;
        this.buttonList.clear();
        DrawbridgeButton button = new DrawbridgeButton(0, cornerX + 131, cornerY + 18, 176, 0, 21, 22);
        if (this.logic.getPlacementDirection() == 0) {
            button.enabled = false;
        }
        this.buttonList.add(button);
        button = new DrawbridgeButton(1, cornerX + 146, cornerY + 34, 199, 23, 22, 21);
        if (this.logic.getPlacementDirection() == 1) {
            button.enabled = false;
        }
        this.buttonList.add(button);
        button = new DrawbridgeButton(2, cornerX + 132, cornerY + 48, 199, 0, 21, 22);
        if (this.logic.getPlacementDirection() == 2) {
            button.enabled = false;
        }
        this.buttonList.add(button);
        button = new DrawbridgeButton(3, cornerX + 117, cornerY + 34, 178, 23, 22, 21);
        if (this.logic.getPlacementDirection() == 3) {
            button.enabled = false;
        }
        this.buttonList.add(button);
        button = new DrawbridgeButton(4, cornerX + 135, cornerY + 40, 217, 0, 10, 10);
        if (this.logic.getPlacementDirection() == 4) {
            button.enabled = false;
        }
        this.buttonList.add(button);
    }

    protected void actionPerformed(GuiButton button) {
        for (Object o : this.buttonList) {
            GuiButton b = (GuiButton)o;
            b.enabled = true;
        }
        button.enabled = false;
        this.updateServer((byte)button.id);
    }

    void updateServer(byte direction) {
        TMechworks.packetPipeline.sendToServer(new PacketDrawbridge(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord, direction));
    }
}

