/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import tmechworks.blocks.SignalBus;
import tmechworks.blocks.logic.SignalBusLogic;

public class SignalBusRender
implements ISimpleBlockRenderingHandler {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        renderer.setRenderBounds(0.375, 0.0, 0.375, 0.625, 0.2, 0.625);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.setRenderBounds(0.375, 0.0, 0.0, 0.625, 0.2, 0.375);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.setRenderBounds(0.375, 0.0, 0.625, 0.625, 0.2, 1.0);
        this.renderStandardBlock(block, metadata, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean didRender = false;
        if (modelId == renderID) {
            SignalBusLogic tile = (SignalBusLogic)world.getTileEntity(x, y, z);
            boolean[] placedSides = tile.placedSides();
            for (int i = 0; i < 6; ++i) {
                if (!placedSides[i]) continue;
                didRender = true;
                boolean[] connectedSides = tile.connectedSides(ForgeDirection.getOrientation((int)i));
                boolean[] corners = tile.getRenderCorners(ForgeDirection.getOrientation((int)i));
                this.renderFaceWithConnections(renderer, block, x, y, z, i, placedSides, connectedSides, corners);
            }
            if (!didRender) {
                double minX = SignalBus.BusGeometry.cable_width_min;
                double minY = SignalBus.BusGeometry.cable_low_offset;
                double minZ = SignalBus.BusGeometry.cable_width_min;
                double maxX = SignalBus.BusGeometry.cable_width_max;
                double maxY = SignalBus.BusGeometry.cable_low_height;
                double maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.renderStandardBlock(block, x, y, z);
            }
        }
        return true;
    }

    private void renderFaceWithConnections(RenderBlocks renderer, Block block, int x, int y, int z, int side, boolean[] placed, boolean[] connectedSides, boolean[] corners) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        boolean[] renderDir = new boolean[]{connectedSides[0] || placed[0] || corners[0], connectedSides[1] || placed[1] || corners[1], connectedSides[2] || placed[2] || corners[2], connectedSides[3] || placed[3] || corners[3], connectedSides[4] || placed[4] || corners[4], connectedSides[5] || placed[5] || corners[5]};
        switch (side) {
            case 0: {
                if (renderDir[ForgeDirection.WEST.ordinal()] || renderDir[ForgeDirection.EAST.ordinal()]) {
                    minX = renderDir[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_low_offset;
                    minZ = SignalBus.BusGeometry.cable_width_min;
                    maxX = renderDir[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_low_height;
                    maxZ = SignalBus.BusGeometry.cable_width_max;
                    minX = corners[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minX;
                    maxX = corners[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxX;
                    renderer.setRenderBounds(minX, minY, minZ, SignalBus.BusGeometry.cable_width_min, maxY += SignalBus.BusGeometry.zfight, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(SignalBus.BusGeometry.cable_width_max, minY, minZ, maxX, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                if (renderDir[ForgeDirection.NORTH.ordinal()] || renderDir[ForgeDirection.SOUTH.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_low_offset;
                    minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_low_height;
                    maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    minZ = corners[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minZ;
                    maxZ = corners[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxZ;
                    renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, SignalBus.BusGeometry.cable_width_min);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(minX, minY, SignalBus.BusGeometry.cable_width_max, maxX, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_width_min;
                minY = SignalBus.BusGeometry.cable_low_offset;
                minZ = SignalBus.BusGeometry.cable_width_min;
                maxX = SignalBus.BusGeometry.cable_width_max;
                maxY = SignalBus.BusGeometry.cable_low_height;
                maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.renderStandardBlock(block, x, y, z);
                break;
            }
            case 1: {
                if (renderDir[ForgeDirection.WEST.ordinal()] || renderDir[ForgeDirection.EAST.ordinal()]) {
                    minX = renderDir[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_high_offset;
                    minZ = SignalBus.BusGeometry.cable_width_min;
                    maxX = renderDir[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_high_height;
                    maxZ = SignalBus.BusGeometry.cable_width_max;
                    minX = corners[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minX;
                    maxX = corners[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxX;
                    renderer.setRenderBounds(minX, minY -= SignalBus.BusGeometry.zfight, minZ, SignalBus.BusGeometry.cable_width_min, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(SignalBus.BusGeometry.cable_width_max, minY, minZ, maxX, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                if (renderDir[ForgeDirection.NORTH.ordinal()] || renderDir[ForgeDirection.SOUTH.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_high_offset;
                    minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_high_height;
                    maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    minZ = corners[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minZ;
                    maxZ = corners[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxZ;
                    renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, SignalBus.BusGeometry.cable_width_min);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(minX, minY, SignalBus.BusGeometry.cable_width_max, maxX, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_width_min;
                minY = SignalBus.BusGeometry.cable_high_offset;
                minZ = SignalBus.BusGeometry.cable_width_min;
                maxX = SignalBus.BusGeometry.cable_width_max;
                maxY = SignalBus.BusGeometry.cable_high_height;
                maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.renderStandardBlock(block, x, y, z);
                break;
            }
            case 2: {
                if (renderDir[ForgeDirection.WEST.ordinal()] || renderDir[ForgeDirection.EAST.ordinal()]) {
                    minX = renderDir[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_low_offset;
                    maxX = renderDir[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_low_height;
                    minX = corners[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minX;
                    maxX = corners[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxX;
                    renderer.setRenderBounds(minX, minY, minZ, SignalBus.BusGeometry.cable_width_min, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(SignalBus.BusGeometry.cable_width_max, minY, minZ, maxX, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                if (renderDir[ForgeDirection.DOWN.ordinal()] || renderDir[ForgeDirection.UP.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_width_min;
                    minY = renderDir[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_low_offset;
                    maxX = SignalBus.BusGeometry.cable_width_max;
                    maxY = renderDir[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_low_height;
                    double d = placed[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.setRenderBounds(minX, SignalBus.BusGeometry.cable_width_max, minZ, maxX, maxY -= placed[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(minX, minY += d, minZ, maxX, SignalBus.BusGeometry.cable_width_min, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_width_min;
                minY = SignalBus.BusGeometry.cable_width_min;
                minZ = SignalBus.BusGeometry.cable_low_offset;
                maxX = SignalBus.BusGeometry.cable_width_max;
                maxY = SignalBus.BusGeometry.cable_width_max;
                maxZ = SignalBus.BusGeometry.cable_low_height;
                renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.renderStandardBlock(block, x, y, z);
                break;
            }
            case 3: {
                if (renderDir[ForgeDirection.WEST.ordinal()] || renderDir[ForgeDirection.EAST.ordinal()]) {
                    minX = renderDir[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_high_offset;
                    maxX = renderDir[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_high_height;
                    minX = corners[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minX;
                    maxX = corners[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxX;
                    renderer.setRenderBounds(minX, minY, minZ, SignalBus.BusGeometry.cable_width_min, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(SignalBus.BusGeometry.cable_width_max, minY, minZ, maxX, maxY, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                if (renderDir[ForgeDirection.DOWN.ordinal()] || renderDir[ForgeDirection.UP.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_width_min;
                    minY = renderDir[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_high_offset;
                    maxX = SignalBus.BusGeometry.cable_width_max;
                    maxY = renderDir[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_high_height;
                    double d = placed[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.setRenderBounds(minX, SignalBus.BusGeometry.cable_width_max, minZ, maxX, maxY -= placed[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(minX, minY += d, minZ, maxX, SignalBus.BusGeometry.cable_width_min, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_width_min;
                minY = SignalBus.BusGeometry.cable_width_min;
                minZ = SignalBus.BusGeometry.cable_high_offset;
                maxX = SignalBus.BusGeometry.cable_width_max;
                maxY = SignalBus.BusGeometry.cable_width_max;
                maxZ = SignalBus.BusGeometry.cable_high_height;
                renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.renderStandardBlock(block, x, y, z);
                break;
            }
            case 4: {
                if (renderDir[ForgeDirection.NORTH.ordinal()] || renderDir[ForgeDirection.SOUTH.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_low_offset;
                    minY = SignalBus.BusGeometry.cable_width_min;
                    minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_low_height;
                    maxY = SignalBus.BusGeometry.cable_width_max;
                    maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    double d = placed[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.setRenderBounds(minX, minY, minZ += placed[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxX, maxY, SignalBus.BusGeometry.cable_width_min);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(minX, minY, SignalBus.BusGeometry.cable_width_max, maxX, maxY, maxZ -= d);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                if (renderDir[ForgeDirection.DOWN.ordinal()] || renderDir[ForgeDirection.UP.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_low_offset;
                    minY = renderDir[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_low_height;
                    maxY = renderDir[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_width_max;
                    double d = placed[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.setRenderBounds(minX, SignalBus.BusGeometry.cable_width_max, minZ, maxX, maxY -= placed[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(minX, minY += d, minZ, maxX, SignalBus.BusGeometry.cable_width_min, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_low_offset;
                minY = SignalBus.BusGeometry.cable_width_min;
                minZ = SignalBus.BusGeometry.cable_width_min;
                maxX = SignalBus.BusGeometry.cable_low_height;
                maxY = SignalBus.BusGeometry.cable_width_max;
                maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.renderStandardBlock(block, x, y, z);
                break;
            }
            case 5: {
                if (renderDir[ForgeDirection.NORTH.ordinal()] || renderDir[ForgeDirection.SOUTH.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_high_offset;
                    minY = SignalBus.BusGeometry.cable_width_min;
                    minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_high_height;
                    maxY = SignalBus.BusGeometry.cable_width_max;
                    maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    double d = placed[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.setRenderBounds(minX, minY, minZ += placed[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxX, maxY, SignalBus.BusGeometry.cable_width_min);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(minX, minY, SignalBus.BusGeometry.cable_width_max, maxX, maxY, maxZ -= d);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                if (renderDir[ForgeDirection.DOWN.ordinal()] || renderDir[ForgeDirection.UP.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_high_offset;
                    minY = renderDir[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_high_height;
                    maxY = renderDir[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_width_max;
                    double d = placed[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.setRenderBounds(minX, SignalBus.BusGeometry.cable_width_max, minZ, maxX, maxY -= placed[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                    renderer.setRenderBounds(minX, minY += d, minZ, maxX, SignalBus.BusGeometry.cable_width_min, maxZ);
                    renderer.renderStandardBlock(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_high_offset;
                minY = SignalBus.BusGeometry.cable_width_min;
                minZ = SignalBus.BusGeometry.cable_width_min;
                maxX = SignalBus.BusGeometry.cable_high_height;
                maxY = SignalBus.BusGeometry.cable_width_max;
                maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.setRenderBounds(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.renderStandardBlock(block, x, y, z);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void renderStandardBlock(Block block, int meta, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, block.getIcon(0, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, block.getIcon(1, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, block.getIcon(2, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, block.getIcon(3, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, block.getIcon(4, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, block.getIcon(5, meta));
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean shouldRender3DInInventory(int model) {
        return true;
    }

    public int getRenderId() {
        return renderID;
    }
}

