/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import java.util.List;
import mantle.world.CoordTuple;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tmechworks.blocks.FilterBlock;

public class FilterLogic
extends TileEntity
implements ISidedInventory {
    int ticksPerUpdate = 10;
    public static final int[] accessibleSlots = new int[0];

    public void updateEntity() {
        block9: {
            EntityItem entity;
            List list;
            boolean passable;
            FilterBlock filter;
            int metadata;
            CoordTuple position;
            block10: {
                super.updateEntity();
                if (this.worldObj.getTotalWorldTime() % (long)this.ticksPerUpdate != 0L) break block9;
                position = new CoordTuple((double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
                metadata = this.worldObj.getBlockMetadata(position.x, position.y, position.z);
                filter = (FilterBlock)this.worldObj.getBlock(position.x, position.y, position.z);
                passable = false;
                if (this.worldObj.getBlock(position.x, position.y - 1, position.z) == null) {
                    passable = true;
                } else if (this.worldObj.getBlock(position.x, position.y - 1, position.z).isAir((IBlockAccess)this.worldObj, position.x, position.y - 1, position.z)) {
                    passable = true;
                }
                IInventory inv = FilterLogic.getInventoryAtLocation(this.worldObj, new CoordTuple((double)position.x, (double)(position.y - 1), (double)position.z));
                if (inv != null && !filter.isTop((IBlockAccess)this.worldObj, position)) {
                    list = FilterLogic.getEntitiesIn(this.worldObj, position);
                    for (Object item : list) {
                        if (!(item instanceof EntityItem)) continue;
                        entity = (EntityItem)item;
                        if (filter.subFilters[filter.getSubFilter(metadata)] == null || !filter.subFilters[filter.getSubFilter(metadata)].canPass((Entity)entity) || this.worldObj.isRemote) continue;
                        FilterLogic.insertStackFromEntity(inv, entity);
                    }
                }
                if ((inv = FilterLogic.getInventoryAtLocation(this.worldObj, new CoordTuple((double)position.x, (double)(position.y + 1), (double)position.z))) == null) break block10;
                if (!filter.isTop((IBlockAccess)this.worldObj, position)) break block9;
                for (int i = 0; i < inv.getSizeInventory(); ++i) {
                    ItemStack itemStack = inv.getStackInSlot(i);
                    if (itemStack == null || filter.subFilters[filter.getSubFilter(metadata)] == null || !filter.subFilters[filter.getSubFilter(metadata)].canPass(itemStack) || this.worldObj.isRemote) continue;
                    ItemStack resultStack = inv.decrStackSize(i, itemStack.stackSize);
                    EntityItem entityItem = new EntityItem(this.worldObj, (double)position.x + 0.5, (double)position.y + (0.5 - 0.1875), (double)position.z + 0.5);
                    entityItem.setEntityItemStack(resultStack);
                    this.worldObj.spawnEntityInWorld((Entity)entityItem);
                    entityItem.motionX = 0.0;
                    entityItem.motionY = -entityItem.motionY;
                    entityItem.motionZ = 0.0;
                }
                break block9;
            }
            list = null;
            list = filter.isTop((IBlockAccess)this.worldObj, position) ? FilterLogic.getEntitiesIn(this.worldObj, position.x, position.y + 1, position.z) : FilterLogic.getEntitiesIn(this.worldObj, position);
            if (list != null) {
                for (Object item : list) {
                    if (!(item instanceof Entity) || !passable && !filter.isTop((IBlockAccess)this.worldObj, position)) continue;
                    entity = (Entity)item;
                    if (filter.subFilters[filter.getSubFilter(metadata)] == null || !filter.subFilters[filter.getSubFilter(metadata)].canPass((Entity)entity)) continue;
                    entity.motionX = 0.0;
                    entity.motionZ = 0.0;
                    if (filter.isTop((IBlockAccess)this.worldObj, position)) {
                        entity.setPosition(entity.posX, (double)position.y + (0.5 - 0.1875), entity.posZ);
                        continue;
                    }
                    entity.setPosition(entity.posX, (double)position.y - ((double)entity.height + 0.1), entity.posZ);
                }
            }
        }
    }

    public static IInventory getInventoryAtLocation(World world, CoordTuple position) {
        TileEntity tileentity = world.getTileEntity(position.x, position.y, position.z);
        if (tileentity != null && tileentity instanceof IInventory) {
            return (IInventory)tileentity;
        }
        return null;
    }

    public static boolean insertStackFromEntity(IInventory inv, EntityItem entity) {
        boolean flag = false;
        if (entity != null) {
            ItemStack itemstack = entity.getEntityItem().copy();
            ItemStack itemstack1 = FilterLogic.insertStack(inv, itemstack);
            if (itemstack1 != null && itemstack1.stackSize != 0) {
                entity.setEntityItemStack(itemstack1);
            } else {
                flag = true;
                entity.setDead();
            }
        }
        return flag;
    }

    public static ItemStack insertStack(IInventory inv, ItemStack itemStack) {
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack slotStack = inv.getStackInSlot(i);
            int remainingSpace = inv.getInventoryStackLimit();
            if (slotStack != null) {
                remainingSpace -= slotStack.stackSize;
            }
            if (remainingSpace >= itemStack.stackSize) {
                if (slotStack != null) {
                    if (!slotStack.isItemEqual(itemStack)) continue;
                    slotStack.stackSize += itemStack.stackSize;
                    inv.setInventorySlotContents(i, slotStack);
                    return null;
                }
                if (!inv.isItemValidForSlot(i, itemStack)) continue;
                inv.setInventorySlotContents(i, itemStack);
                return null;
            }
            if (slotStack != null) {
                if (!slotStack.isItemEqual(itemStack)) continue;
                slotStack.stackSize += remainingSpace;
                itemStack.stackSize -= remainingSpace;
                inv.setInventorySlotContents(i, slotStack);
                continue;
            }
            if (!inv.isItemValidForSlot(i, itemStack)) continue;
            inv.setInventorySlotContents(i, itemStack.splitStack(remainingSpace));
        }
        return itemStack;
    }

    public static List getEntitiesIn(World world, CoordTuple pos) {
        return FilterLogic.getEntitiesIn(world, pos.x, pos.y, pos.z);
    }

    protected static List getEntitiesIn(World world, int x, int y, int z) {
        return world.selectEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0)), IEntitySelector.selectAnything);
    }

    public int getSizeInventory() {
        return 0;
    }

    public ItemStack getStackInSlot(int i) {
        return null;
    }

    public ItemStack decrStackSize(int i, int j) {
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
    }

    public int getInventoryStackLimit() {
        return 0;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        return accessibleSlots;
    }

    public boolean canInsertItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public void closeInventory() {
    }

    public String getInventoryName() {
        return "TMechworks:Filter";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void openInventory() {
    }
}

