/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.lib.multiblock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.world.World;
import tmechworks.lib.multiblock.IMultiblockMember;
import tmechworks.lib.multiblock.MultiblockMasterBaseLogic;

public class MultiblockRegistry {
    private static Set<MultiblockMasterBaseLogic> masters = new CopyOnWriteArraySet<MultiblockMasterBaseLogic>();
    private static HashMap<Integer, HashMap<Long, List<IMultiblockMember>>> preInitMembers = new HashMap();
    private static HashMap<Integer, HashMap<Long, List<IMultiblockMember>>> preInitMasters = new HashMap();
    private static HashMap<Integer, HashMap<Long, List<IMultiblockMember>>> loadedMembers = new HashMap();

    public static void tick(World world) {
        for (MultiblockMasterBaseLogic logic : masters) {
            if (logic.worldObj != world || logic.worldObj.isRemote != world.isRemote) continue;
            logic.doMultiblockTick();
        }
    }

    public static void register(MultiblockMasterBaseLogic logic) {
        masters.add(logic);
    }

    public static void unregister(MultiblockMasterBaseLogic logic) {
        masters.remove(logic);
    }

    public static void onMemberLoad(World world, Long chunkCoord, IMultiblockMember member, boolean master) {
        HashMap<Integer, HashMap<Long, List<IMultiblockMember>>> pending = preInitMembers;
        if (master) {
            pending = preInitMasters;
        }
        int dimensionId = world.provider.dimensionId;
        MultiblockRegistry.putMemberInList(pending, dimensionId, chunkCoord, member);
    }

    public static void onChunkLoaded(World world, long chunkCoord) {
        int dimensionId = world.provider.dimensionId;
        List<IMultiblockMember> pending = MultiblockRegistry.getMembersFromListForWorldChunk(preInitMasters, dimensionId, chunkCoord);
        if (pending != null) {
            for (IMultiblockMember member : pending) {
                member.onChunkLoad();
            }
            preInitMasters.get(dimensionId).remove(chunkCoord);
        }
        if ((pending = MultiblockRegistry.getMembersFromListForWorldChunk(preInitMembers, dimensionId, chunkCoord)) != null) {
            for (IMultiblockMember member : pending) {
                member.onChunkLoad();
            }
            preInitMembers.get(dimensionId).remove(chunkCoord);
        }
    }

    public static void onChunkUnloaded(World world, long chunkCoord) {
        int dimensionId = world.provider.dimensionId;
        List<IMultiblockMember> pending = MultiblockRegistry.getMembersFromListForWorldChunk(loadedMembers, dimensionId, chunkCoord);
        if (pending != null) {
            for (IMultiblockMember member : pending) {
                member.onChunkUnloaded();
            }
            loadedMembers.get(dimensionId).remove(chunkCoord);
        }
    }

    public static void registerMember(World world, long chunkCoord, IMultiblockMember member) {
        MultiblockRegistry.putMemberInList(loadedMembers, world.provider.dimensionId, chunkCoord, member);
    }

    public static void onWorldUnloaded(World world) {
        ArrayList<MultiblockMasterBaseLogic> mastersToRemove = new ArrayList<MultiblockMasterBaseLogic>();
        for (MultiblockMasterBaseLogic master : mastersToRemove) {
            if (master.worldObj.isRemote != world.isRemote || master.worldObj.provider.dimensionId != world.provider.dimensionId) continue;
            mastersToRemove.add(master);
        }
        masters.removeAll(mastersToRemove);
    }

    private static List<IMultiblockMember> getMembersFromListForWorldChunk(HashMap<Integer, HashMap<Long, List<IMultiblockMember>>> source, int dimensionId, long chunkCoord) {
        if (!source.containsKey(dimensionId)) {
            return null;
        }
        if (!source.get(dimensionId).containsKey(chunkCoord)) {
            return null;
        }
        return source.get(dimensionId).get(chunkCoord);
    }

    private static void putMemberInList(HashMap<Integer, HashMap<Long, List<IMultiblockMember>>> destList, int dimensionId, long chunkCoord, IMultiblockMember member) {
        HashMap<Long, List<IMultiblockMember>> innerMap;
        if (!destList.containsKey(dimensionId)) {
            destList.put(dimensionId, new HashMap());
        }
        if (!(innerMap = destList.get(dimensionId)).containsKey(chunkCoord)) {
            innerMap.put(chunkCoord, new ArrayList());
        }
        innerMap.get(chunkCoord).add(member);
    }
}

