/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import tmechworks.blocks.logic.DrawbridgeLogic;
import tmechworks.inventory.DrawbridgeSlot;
import tmechworks.inventory.SlotOpaqueBlocksOnly;
import tmechworks.lib.TMechworksRegistry;

public class DrawbridgeContainer
extends Container {
    public DrawbridgeLogic logic;
    public int progress = 0;
    public int fuel = 0;
    public int fuelGague = 0;

    public DrawbridgeContainer(InventoryPlayer inventoryplayer, DrawbridgeLogic logic) {
        int column;
        this.logic = logic;
        this.addSlotToContainer(new DrawbridgeSlot((IInventory)logic, 0, 80, 36, logic));
        this.addSlotToContainer(new SlotOpaqueBlocksOnly((IInventory)logic, 1, 35, 36));
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, row + column * 9 + 9, 8 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, column, 8 + column * 18, 142));
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.logic.isUseableByPlayer(entityplayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            stack = slotStack.copy();
            if (slotID < this.logic.getSizeInventory() ? !this.mergeItemStack(slotStack, this.logic.getSizeInventory(), this.inventorySlots.size(), true) : !this.mergeItemStack(slotStack, 0, this.logic.getSizeInventory(), false)) {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return stack;
    }

    protected boolean mergeItemStack(ItemStack stack, int startSlotId, int endSlotId, boolean reverseMerge) {
        if (stack == null || !(stack.getItem() instanceof ItemBlock) || this.logic.hasExtended()) {
            return false;
        }
        if (TMechworksRegistry.isItemDBBlacklisted((ItemBlock)stack.getItem())) {
            return false;
        }
        return super.mergeItemStack(stack, startSlotId, endSlotId, reverseMerge);
    }
}

