/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import java.util.Arrays;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tmechworks.blocks.SignalTerminal;
import tmechworks.blocks.logic.SignalBusLogic;
import tmechworks.common.MechContent;
import tmechworks.lib.signal.ISignalTransceiver;

public class SignalTerminalLogic
extends TileEntity
implements ISignalTransceiver {
    private byte[] connectedSides = new byte[6];
    private byte[] receivingSides = new byte[6];
    private byte[] sideChannel = new byte[6];
    private boolean forceUpdateSide;
    private boolean neighborChanged;
    private byte[] cachedSouthboundSignals;
    private int pendingSide = -1;
    private CoordTuple signalBus = null;
    private boolean doUpdate = false;
    private boolean isRegistered = false;

    public SignalTerminalLogic() {
        for (int i = 0; i < 6; ++i) {
            this.connectedSides[i] = -1;
            this.receivingSides[i] = -1;
            this.sideChannel[i] = 0;
            this.forceUpdateSide = false;
        }
        this.neighborChanged = false;
    }

    private void tryRegister() {
        boolean wasRegistered = this.isRegistered;
        if (!(this.worldObj instanceof World)) {
            return;
        }
        if (!(this.signalBus instanceof CoordTuple)) {
            return;
        }
        TileEntity te = this.worldObj.getTileEntity(this.signalBus.x, this.signalBus.y, this.signalBus.z);
        if (!(te instanceof SignalBusLogic)) {
            return;
        }
        this.isRegistered = ((SignalBusLogic)te).registerTerminal(this.worldObj, this.xCoord, this.yCoord, this.zCoord, false);
        if (this.isRegistered != wasRegistered) {
            if (this.isRegistered) {
                this.doUpdate = true;
            } else {
                this.signalBus = null;
                this.doUpdate = true;
            }
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.sideChannel = data.getByteArray("sideChannel");
        this.receivingSides = data.getByteArray("receivingSides");
        this.connectedSides = data.getByteArray("connectedSides");
        if (this.sideChannel.length != 6) {
            this.sideChannel = new byte[]{0, 0, 0, 0, 0, 0};
        }
        if (this.receivingSides.length != 6) {
            this.receivingSides = new byte[]{-1, -1, -1, -1, -1, -1};
        }
        if (this.connectedSides.length != 6) {
            this.connectedSides = new byte[]{-1, -1, -1, -1, -1, -1};
        }
        int tX = data.getInteger("BusX");
        int tY = data.getInteger("BusY");
        int tZ = data.getInteger("BusZ");
        this.signalBus = tX == this.xCoord && tY == this.yCoord && tZ == this.zCoord ? null : new CoordTuple((double)tX, (double)tY, (double)tZ);
        if (!this.isRegistered) {
            this.tryRegister();
        }
        this.doUpdate = true;
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setByteArray("sideChannel", this.sideChannel);
        data.setByteArray("receivingSides", this.receivingSides);
        data.setByteArray("connectedSides", this.connectedSides);
        if (this.signalBus != null) {
            data.setInteger("BusX", this.signalBus.x);
            data.setInteger("BusY", this.signalBus.y);
            data.setInteger("BusZ", this.signalBus.z);
        } else {
            data.setInteger("BusX", this.xCoord);
            data.setInteger("BusY", this.yCoord);
            data.setInteger("BusZ", this.zCoord);
        }
    }

    public void updateEntity() {
        if (this.pendingSide >= 0 && this.pendingSide < 6 && this.connectedSides[this.pendingSide] == -1) {
            this.connectedSides[this.pendingSide] = 0;
            this.pendingSide = -1;
            this.forceUpdateSide = true;
        }
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.forceUpdateSide || this.neighborChanged) {
            this.checkNeighbors();
            this.neighborChanged = false;
            this.forceUpdateSide = false;
        }
        if (!this.doUpdate) {
            return;
        }
        if (!this.isRegistered) {
            this.tryRegister();
        }
        if (this.cachedSouthboundSignals != null) {
            this.processSignalUpdate(this.cachedSouthboundSignals);
        }
        this.doUpdate = false;
    }

    @Override
    public void receiveSignalUpdate(byte[] signals) {
        if (!Arrays.equals(this.cachedSouthboundSignals, signals)) {
            this.cachedSouthboundSignals = (byte[])signals.clone();
            this.doUpdate = true;
        }
    }

    private void processSignalUpdate(byte[] signals) {
        int targetX = 0;
        int targetY = 0;
        int targetZ = 0;
        for (int i = 0; i < 6; ++i) {
            int oSide;
            if (this.connectedSides[i] == -1) continue;
            byte oldValue = this.connectedSides[i];
            this.connectedSides[i] = signals[this.sideChannel[i]];
            if (oldValue == this.connectedSides[i]) continue;
            targetX = this.xCoord;
            targetY = this.yCoord;
            targetZ = this.zCoord;
            switch (i) {
                case 0: {
                    --targetY;
                    oSide = 1;
                    break;
                }
                case 1: {
                    ++targetY;
                    oSide = 0;
                    break;
                }
                case 2: {
                    ++targetZ;
                    oSide = 2;
                    break;
                }
                case 3: {
                    --targetZ;
                    oSide = 3;
                    break;
                }
                case 4: {
                    --targetX;
                    oSide = 5;
                    break;
                }
                case 5: {
                    ++targetX;
                    oSide = 4;
                    break;
                }
                default: {
                    oSide = 0;
                }
            }
            this.worldObj.notifyBlockOfNeighborChange(targetX, targetY, targetZ, MechContent.signalTerminal);
            this.worldObj.notifyBlocksOfNeighborChange(targetX, targetY, targetZ, MechContent.signalTerminal, oSide);
        }
    }

    @Override
    public void setBusCoords(World world, int x, int y, int z) {
        if (world.provider.dimensionId == this.worldObj.provider.dimensionId && !world.isRemote && !this.worldObj.isRemote) {
            this.signalBus = new CoordTuple((double)x, (double)y, (double)z);
            world.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        this.doUpdate = true;
    }

    public int isProvidingWeakPower(int side) {
        return this.isProvidingStrongPower(side);
    }

    public int isProvidingStrongPower(int side) {
        int tside = side;
        switch (side) {
            case 0: {
                tside = 1;
                break;
            }
            case 1: {
                tside = 0;
                break;
            }
            case 2: {
                tside = 2;
                break;
            }
            case 3: {
                tside = 3;
                break;
            }
            case 4: {
                tside = 5;
                break;
            }
            case 5: {
                tside = 4;
                break;
            }
            default: {
                tside = side;
            }
        }
        if (tside >= 0 && tside < 6 && this.connectedSides[tside] > 0) {
            return this.connectedSides[tside] - 1;
        }
        return 0;
    }

    public void addPendingSide(int side) {
        this.pendingSide = side;
    }

    public void connectPending() {
        if (this.pendingSide >= 0 && this.pendingSide < 6 && this.connectedSides[this.pendingSide] == -1) {
            this.connectedSides[this.pendingSide] = 0;
        }
        this.pendingSide = -1;
        this.doUpdate = true;
    }

    public byte[] getConnectedSides() {
        return (byte[])this.connectedSides.clone();
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readFromNBT(packet.func_148857_g());
        this.markDirty();
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        this.doUpdate = true;
    }

    public static IIcon getChannelIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof SignalTerminalLogic) {
            byte channel = ((SignalTerminalLogic)te).sideChannel[side];
            return ((SignalTerminal)MechContent.signalTerminal).getChannelIcon(channel);
        }
        return ((SignalTerminal)MechContent.signalTerminal).getChannelIcon(0);
    }

    public static IIcon[] getChannelIcons() {
        return ((SignalTerminal)MechContent.signalTerminal).channelIcons;
    }

    public static IIcon getChannelIcon(int channel) {
        return SignalTerminalLogic.getChannelIcons()[channel];
    }

    public IIcon getChannelIconFromLogic(int side) {
        return SignalTerminalLogic.getChannelIcons()[this.sideChannel[side]];
    }

    public void nextChannel(int side) {
        if (this.worldObj.isRemote) {
            return;
        }
        int n = side;
        this.sideChannel[n] = (byte)(this.sideChannel[n] + 1);
        if (this.sideChannel[side] >= 16) {
            this.sideChannel[side] = 0;
        }
        this.doUpdate = true;
    }

    public void prevChannel(int side) {
        if (this.worldObj.isRemote) {
            return;
        }
        int n = side;
        this.sideChannel[n] = (byte)(this.sideChannel[n] - 1);
        if (this.sideChannel[side] < 0) {
            this.sideChannel[side] = 15;
        }
        this.doUpdate = true;
    }

    public void notifyBreak() {
        if (!(this.worldObj instanceof World) || this.worldObj.isRemote) {
            return;
        }
        if (!(this.signalBus instanceof CoordTuple)) {
            return;
        }
        TileEntity te = this.worldObj.getTileEntity(this.signalBus.x, this.signalBus.y, this.signalBus.z);
        if (te == null || !(te instanceof SignalBusLogic)) {
            return;
        }
        ((SignalBusLogic)te).unregisterTerminal(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    public void onNeighborBlockChange() {
        if (this.worldObj.isRemote) {
            return;
        }
        this.neighborChanged = true;
    }

    public void checkNeighbors() {
        if (this.signalBus != null && this.signalBus instanceof CoordTuple) {
            TileEntity te = this.worldObj.getTileEntity(this.signalBus.x, this.signalBus.y, this.signalBus.z);
            if (te instanceof SignalBusLogic) {
                ((SignalBusLogic)te).updateTransceiverSignals(new CoordTuple((double)this.xCoord, (double)this.yCoord, (double)this.zCoord), this.getReceivedSignals());
            }
        } else {
            this.receiveSignalUpdate(this.getReceivedSignals());
        }
    }

    public IIcon[] getSideIcons() {
        IIcon[] icons = SignalTerminalLogic.getChannelIcons();
        IIcon[] sideIcons = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            sideIcons[i] = this.sideChannel[i] > 0 ? icons[this.sideChannel[i]] : icons[0];
        }
        return sideIcons;
    }

    public byte[] getReceivedSignals(boolean vanillaRedstoneKludge) {
        byte[] highChannel = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] offset = new int[]{0, 0, 0};
        for (int i = 0; i < 6; ++i) {
            int oSide;
            if (this.connectedSides[i] == -1) continue;
            offset[0] = 0;
            offset[1] = 0;
            offset[2] = 0;
            switch (i) {
                case 0: {
                    offset[1] = offset[1] + -1;
                    oSide = 1;
                    break;
                }
                case 1: {
                    offset[1] = offset[1] + 1;
                    oSide = 0;
                    break;
                }
                case 2: {
                    offset[2] = offset[2] + 1;
                    oSide = 3;
                    break;
                }
                case 3: {
                    offset[2] = offset[2] + -1;
                    oSide = 2;
                    break;
                }
                case 4: {
                    offset[0] = offset[0] + -1;
                    oSide = 5;
                    break;
                }
                case 5: {
                    offset[0] = offset[0] + 1;
                    oSide = 4;
                    break;
                }
                default: {
                    oSide = i;
                }
            }
            int tempStrength = 0;
            if (this.connectedSides[i] > 0) {
                byte temporarySide = this.connectedSides[i];
                this.connectedSides[i] = -1;
                tempStrength = this.worldObj.getIndirectPowerLevelTo(this.xCoord + offset[0], this.yCoord + offset[1], this.zCoord + offset[2], oSide);
                if (tempStrength > 0 && tempStrength == temporarySide - 1) {
                    int power = 0;
                    int temp = 0;
                    for (int j = 0; j < 6; ++j) {
                        Block bid;
                        if (offset[0] + Facing.offsetsXForSide[j] == 0 && offset[1] + Facing.offsetsYForSide[j] == 0 && offset[2] + Facing.offsetsZForSide[j] == 0) continue;
                        temp = this.worldObj.getIndirectPowerLevelTo(this.xCoord + offset[0] + Facing.offsetsXForSide[j], this.yCoord + offset[1] + Facing.offsetsYForSide[j], this.zCoord + offset[2] + Facing.offsetsZForSide[j], j);
                        if (temp > power && (bid = this.worldObj.getBlock(this.xCoord + offset[0] + Facing.offsetsXForSide[j], this.yCoord + offset[1] + Facing.offsetsYForSide[j], this.zCoord + offset[2] + Facing.offsetsZForSide[j])) != Blocks.redstone_wire) {
                            power = temp;
                        }
                        if (power == tempStrength) break;
                    }
                    tempStrength = power;
                }
                this.connectedSides[i] = temporarySide;
            } else {
                tempStrength = this.worldObj.getIndirectPowerLevelTo(this.xCoord + offset[0], this.yCoord + offset[1], this.zCoord + offset[2], oSide);
            }
            this.receivingSides[i] = tempStrength > 0 ? (byte)(tempStrength - 1) : (byte)0;
            if (this.receivingSides[i] <= highChannel[this.sideChannel[i]]) continue;
            highChannel[this.sideChannel[i]] = this.receivingSides[i];
        }
        return highChannel;
    }

    @Override
    public int doUnregister(boolean reHoming) {
        int dropWire = 0;
        if (this.signalBus != null) {
            TileEntity te = this.worldObj.getTileEntity(this.signalBus.x, this.signalBus.y, this.signalBus.z);
            dropWire = Math.abs(this.xCoord - this.signalBus.x) + Math.abs(this.yCoord - this.signalBus.y) + Math.abs(this.zCoord - this.signalBus.z);
            if (te instanceof SignalBusLogic) {
                ((SignalBusLogic)te).unregisterTerminal(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
        this.signalBus = null;
        this.receiveSignalUpdate(this.getReceivedSignals());
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return reHoming ? dropWire : 0;
    }

    @Override
    public byte[] getReceivedSignals() {
        return this.getReceivedSignals(false);
    }

    public int getDroppedTerminals() {
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.connectedSides[i] == -1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getDroppedWire() {
        int calcWire = 0;
        if (this.signalBus instanceof CoordTuple) {
            calcWire += Math.abs(this.signalBus.x - this.xCoord);
            calcWire += Math.abs(this.signalBus.y - this.yCoord);
            return calcWire += Math.abs(this.signalBus.z - this.zCoord);
        }
        return 0;
    }

    @Override
    public CoordTuple getBusCoords() {
        return this.signalBus;
    }
}

