/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.BlockInventory;
import slimeknights.mantle.property.PropertyString;
import slimeknights.mantle.property.PropertyUnlistedDirection;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.shared.tileentity.TileTable;

public class BlockTable
extends BlockInventory
implements ITileEntityProvider {
    public static final PropertyString TEXTURE = new PropertyString("texture");
    public static final PropertyTableItem INVENTORY = new PropertyTableItem();
    public static final PropertyUnlistedDirection FACING = new PropertyUnlistedDirection("facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockTable(Material materialIn) {
        super(materialIn);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTable("tile.table", 0, 0);
    }

    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        return false;
    }

    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            return table.writeExtendedBlockState(extendedState);
        }
        return super.getExtendedState(state, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            NBTTagCompound feetTag = tag.func_74775_l("textureBlock");
            if (feetTag == null) {
                feetTag = new NBTTagCompound();
            }
            table.updateTextureBlock(feetTag);
            table.setFacing(placer.func_174811_aO().func_176734_d());
            if (tag.func_74764_b("inventory")) {
                TileInventory.readInventoryFromNBT((IInventory)table, (NBTTagCompound)tag.func_74775_l("inventory"));
            }
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te;
        IBlockState state = world.func_180495_p(pos);
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos));
        }
        if (this.keepInventory(state) && (te = world.func_175625_s(pos)) instanceof TileInventory) {
            ((TileInventory)te).func_174888_l();
        }
        world.func_175698_g(pos);
        return false;
    }

    protected boolean keepInventory(IBlockState state) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List items = super.getDrops(world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            NBTTagCompound data = table.getTextureBlock();
            for (ItemStack item : items) {
                if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                NBTTagCompound tag = TagUtil.getTagSafe(item);
                tag.func_74782_a("textureBlock", (NBTBase)data);
                item.func_77982_d(tag);
                if (!this.keepInventory(state)) continue;
                NBTTagCompound inventoryTag = new NBTTagCompound();
                TileInventory.writeInventoryToNBT((IInventory)table, (NBTTagCompound)inventoryTag);
                tag.func_74782_a("inventory", (NBTBase)inventoryTag);
            }
        }
        return items;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        List<ItemStack> drops = this.getDrops((IBlockAccess)world, pos, world.func_180495_p(pos), 0);
        if (drops.size() > 0) {
            return drops.get(0);
        }
        return super.getPickBlock(target, world, pos, player);
    }

    public static ItemStack createItemstack(BlockTable table, int tableMeta, Block block, int blockMeta) {
        ItemStack stack = new ItemStack((Block)table, 1, tableMeta);
        if (block != null) {
            ItemStack blockStack = new ItemStack(block, 1, blockMeta);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            blockStack.func_77955_b(subTag);
            tag.func_74782_a("textureBlock", (NBTBase)subTag);
            stack.func_77982_d(tag);
        }
        return stack;
    }
}

