/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlime;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.worldgen.SlimeTreeGenerator;

public class BlockSlimeSapling
extends BlockSapling {
    public static PropertyEnum<BlockSlimeGrass.FoliageType> FOLIAGE = BlockSlimeGrass.FOLIAGE;

    public BlockSlimeSapling() {
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabWorld);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(field_149779_h);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (BlockSlimeGrass.FoliageType type : BlockSlimeGrass.FoliageType.values()) {
            list.add(new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FOLIAGE, field_176479_b, field_176480_a});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= BlockSlimeGrass.FoliageType.values().length) {
            meta = 0;
        }
        BlockSlimeGrass.FoliageType grass = BlockSlimeGrass.FoliageType.values()[meta];
        return this.func_176223_P().func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)grass));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockSlimeGrass.FoliageType)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        return 0xFFFFFF;
    }

    public boolean func_176200_f(World worldIn, BlockPos pos) {
        return false;
    }

    protected boolean func_149854_a(Block ground) {
        return ground == TinkerWorld.slimeGrass || ground == TinkerWorld.slimeDirt;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return TinkerWorld.slimePlantType;
    }

    public int func_176222_j(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        return iblockstate.func_177230_c().func_176201_c(iblockstate);
    }

    public void func_176476_e(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        BlockSlime.SlimeType slimeType = BlockSlime.SlimeType.GREEN;
        if (state.func_177229_b(FOLIAGE) == BlockSlimeGrass.FoliageType.ORANGE) {
            slimeType = BlockSlime.SlimeType.MAGMA;
        }
        IBlockState slimeGreen = TinkerWorld.slimeBlockCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)slimeType));
        IBlockState leaves = TinkerWorld.slimeLeaves.func_176223_P().func_177226_a(BlockSlimeGrass.FOLIAGE, state.func_177229_b(FOLIAGE));
        SlimeTreeGenerator gen = new SlimeTreeGenerator(5, 4, slimeGreen, leaves, null);
        worldIn.func_175698_g(pos);
        gen.generateTree(rand, worldIn, pos);
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }
}

