/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ModHaste
extends Modifier {
    private final int max;

    public ModHaste(int max) {
        super("haste");
        this.max = max;
        this.addAspects(new ModifierAspect.MultiAspect(this, 0x910000, 5, max, 1), ModifierAspect.harvestOnly);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        ToolNBT toolData = TagUtil.getOriginalToolStats(rootCompound);
        float speed = toolData.speed;
        int level = data.current / this.max;
        for (int count = data.current; count > 0; --count) {
            if (speed <= 10.0f) {
                speed += 0.15f - 0.05f * speed / 10.0f;
                continue;
            }
            speed = speed <= 20.0f ? (float)((double)speed + ((double)0.1f - 0.05 * (double)speed / 20.0)) : (float)((double)speed + 0.05);
        }
        speed += (float)level * 0.5f;
        NBTTagCompound tag = TagUtil.getToolTag(rootCompound);
        speed -= toolData.speed;
        tag.func_74776_a("MiningSpeed", speed += tag.func_74760_g("MiningSpeed"));
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }
}

