/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.BroadSword;
import slimeknights.tconstruct.tools.network.EntityMovementChangePacket;

public class BattleSign
extends BroadSword {
    public BattleSign() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.signHead));
    }

    @Override
    public int attackSpeed() {
        return 0;
    }

    @Override
    public float damagePotential() {
        return 0.86f;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void reducedDamageBlocked(LivingHurtEvent event) {
        if (event.source.func_76363_c() || event.source.func_82725_o() || event.source.func_94541_c() || event.source.func_76352_a() || event.isCanceled()) {
            return;
        }
        if (!this.shouldBlockDamage((Entity)event.entityLiving)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        ItemStack battlesign = player.func_71045_bC();
        int damage = event.ammount < 2.0f ? 1 : Math.round(event.ammount / 2.0f);
        event.ammount *= 0.7f;
        if (event.source.func_76346_g() != null) {
            event.source.func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)player), event.ammount / 2.0f);
            damage = damage * 3 / 2;
        }
        ToolHelper.damageTool(battlesign, damage, (EntityLivingBase)player);
    }

    @SubscribeEvent
    public void reflectProjectiles(LivingAttackEvent event) {
        if (event.source.func_76363_c() || !event.source.func_76352_a()) {
            return;
        }
        if (!this.shouldBlockDamage((Entity)event.entityLiving)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        ItemStack battlesign = player.func_71045_bC();
        Entity projectile = event.source.func_76364_f();
        Vec3 motion = new Vec3(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y);
        Vec3 look = player.func_70040_Z();
        double strength = -look.func_72430_b(motion.func_72432_b());
        if (strength < 0.1) {
            return;
        }
        event.setCanceled(true);
        double speed = projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y;
        speed = Math.sqrt(speed);
        projectile.field_70159_w = look.field_72450_a * (speed += (double)0.2f);
        projectile.field_70181_x = look.field_72448_b * speed;
        projectile.field_70179_y = look.field_72449_c * speed;
        projectile.field_70177_z = (float)(Math.atan2(projectile.field_70159_w, projectile.field_70179_y) * 180.0 / Math.PI);
        projectile.field_70125_A = (float)(Math.atan2(projectile.field_70181_x, speed) * 180.0 / Math.PI);
        TinkerNetwork.sendToAll((AbstractPacket)new EntityMovementChangePacket(projectile));
        if (projectile instanceof EntityArrow) {
            ((EntityArrow)projectile).field_70250_c = player;
            projectile.field_70159_w /= (double)-0.1f;
            projectile.field_70181_x /= (double)-0.1f;
            projectile.field_70179_y /= (double)-0.1f;
        }
        ToolHelper.damageTool(battlesign, (int)event.ammount, (EntityLivingBase)player);
    }

    protected boolean shouldBlockDamage(Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!player.func_70632_aY() || player.func_71045_bC().func_77973_b() != this) {
            return false;
        }
        return !ToolHelper.isBroken(player.func_71045_bC());
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        return this.buildDefaultTag(materials).get();
    }
}

