/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.tconstruct.tools.block.BlockToolTable;
import slimeknights.tconstruct.tools.block.ITinkerStationBlock;
import slimeknights.tconstruct.tools.client.GuiTinkerStation;

public class ContainerTinkerStation<T extends TileEntity>
extends ContainerMultiModule<T> {
    public final boolean hasCraftingStation;
    public final List<Pair<BlockPos, IBlockState>> tinkerStationBlocks = Lists.newLinkedList();

    public ContainerTinkerStation(T tile) {
        super(tile);
        this.hasCraftingStation = this.detectedTinkerStationParts(tile.func_145831_w(), tile.func_174877_v());
    }

    public <TE extends TileEntity> TE getTinkerTE(Class<TE> clazz) {
        for (Pair<BlockPos, IBlockState> pair : this.tinkerStationBlocks) {
            TileEntity te = this.world.func_175625_s((BlockPos)pair.getLeft());
            if (te == null || !clazz.isAssignableFrom(te.getClass())) continue;
            return (TE)te;
        }
        return null;
    }

    public boolean detectedTinkerStationParts(World world, BlockPos start) {
        HashSet found = Sets.newHashSet();
        HashSet visited = Sets.newHashSet();
        HashSet ret = Sets.newHashSet();
        boolean hasMaster = false;
        PriorityQueue queue = Queues.newPriorityQueue();
        queue.add(start);
        while (!queue.isEmpty()) {
            BlockToolTable.TableTypes type;
            IBlockState state;
            BlockPos pos = (BlockPos)queue.poll();
            if (visited.contains(pos) || !((state = world.func_180495_p(pos)).func_177230_c() instanceof ITinkerStationBlock)) continue;
            if (!visited.contains(pos.func_177978_c())) {
                queue.add(pos.func_177978_c());
            }
            if (!visited.contains(pos.func_177974_f())) {
                queue.add(pos.func_177974_f());
            }
            if (!visited.contains(pos.func_177968_d())) {
                queue.add(pos.func_177968_d());
            }
            if (!visited.contains(pos.func_177976_e())) {
                queue.add(pos.func_177976_e());
            }
            visited.add(pos);
            ITinkerStationBlock tinker = (ITinkerStationBlock)state.func_177230_c();
            Integer number = tinker.getGuiNumber(state);
            if (found.contains(number)) continue;
            found.add(number);
            this.tinkerStationBlocks.add((Pair<BlockPos, IBlockState>)Pair.of((Object)pos, (Object)state));
            ret.add(state);
            if (!state.func_177228_b().containsKey(BlockToolTable.TABLES) || (type = (BlockToolTable.TableTypes)((Object)state.func_177229_b(BlockToolTable.TABLES))) == null || type != BlockToolTable.TableTypes.CraftingStation) continue;
            hasMaster = true;
        }
        TinkerBlockComp comp = new TinkerBlockComp();
        Collections.sort(this.tinkerStationBlocks, comp);
        return hasMaster;
    }

    public void updateGUI() {
        if (this.tile.func_145831_w().field_72995_K) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ContainerTinkerStation.clientGuiUpdate();
                }
            });
        }
    }

    public void error(final String message) {
        if (this.tile.func_145831_w().field_72995_K) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ContainerTinkerStation.clientError(message);
                }
            });
        }
    }

    public void warning(final String message) {
        if (this.tile.func_145831_w().field_72995_K) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ContainerTinkerStation.clientWarning(message);
                }
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void clientGuiUpdate() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiTinkerStation) {
            ((GuiTinkerStation)screen).updateDisplay();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void clientError(String message) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiTinkerStation) {
            ((GuiTinkerStation)screen).error(message);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void clientWarning(String message) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiTinkerStation) {
            ((GuiTinkerStation)screen).warning(message);
        }
    }

    private static class TinkerBlockComp
    implements Comparator<Pair<BlockPos, IBlockState>> {
        private TinkerBlockComp() {
        }

        @Override
        public int compare(Pair<BlockPos, IBlockState> o1, Pair<BlockPos, IBlockState> o2) {
            IBlockState s1 = (IBlockState)o1.getRight();
            IBlockState s2 = (IBlockState)o2.getRight();
            return ((ITinkerStationBlock)s2.func_177230_c()).getGuiNumber(s2) - ((ITinkerStationBlock)s1.func_177230_c()).getGuiNumber(s1);
        }
    }
}

