/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;

public class SmelteryFuelUpdatePacket
extends AbstractPacketThreadsafe {
    BlockPos pos;
    BlockPos tank;
    int temperature;
    FluidStack fuel;

    public SmelteryFuelUpdatePacket() {
    }

    public SmelteryFuelUpdatePacket(BlockPos pos, BlockPos tank, int temperature, FluidStack fuel) {
        this.pos = pos;
        this.tank = tank;
        this.temperature = temperature;
        this.fuel = fuel;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (te instanceof TileSmeltery) {
            TileSmeltery smeltery = (TileSmeltery)te;
            smeltery.currentFuel = this.fuel;
            smeltery.currentTank = this.tank;
            smeltery.updateTemperatureFromPacket(this.temperature);
        }
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Clientside only");
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        this.tank = this.readPos(buf);
        this.temperature = buf.readInt();
        NBTTagCompound fluidTag = ByteBufUtils.readTag((ByteBuf)buf);
        this.fuel = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        this.writePos(this.tank, buf);
        buf.writeInt(this.temperature);
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.fuel.writeToNBT(fluidTag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)fluidTag);
    }
}

