/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.tools.block.ITinkerStationBlock;
import slimeknights.tconstruct.tools.client.module.GuiTinkerTabs;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.network.TinkerStationTabPacket;

@SideOnly(value=Side.CLIENT)
public class GuiTinkerStation
extends GuiMultiModule {
    public static final ResourceLocation ICONS = Util.getResource("textures/gui/icons.png");
    public static final ResourceLocation BLANK_BACK = Util.getResource("textures/gui/blank.png");
    public static final GuiElement ICON_Anvil = new GuiElement(54, 0, 18, 18, 256, 256);
    public static final GuiElement ICON_Pattern = new GuiElement(0, 216, 18, 18);
    public static final GuiElement ICON_Shard = new GuiElement(18, 216, 18, 18);
    public static final GuiElement ICON_Block = new GuiElement(36, 216, 18, 18);
    public static final GuiElement ICON_Pickaxe = new GuiElement(0, 234, 18, 18);
    public static final GuiElement ICON_Dust = new GuiElement(18, 234, 18, 18);
    public static final GuiElement ICON_Lapis = new GuiElement(36, 234, 18, 18);
    public static final GuiElement ICON_Ingot = new GuiElement(54, 234, 18, 18);
    public static final GuiElement ICON_Gem = new GuiElement(72, 234, 18, 18);
    public static final GuiElement ICON_Quartz = new GuiElement(90, 234, 18, 18);
    public static final GuiElement ICON_Button = new GuiElement(180, 216, 18, 18);
    public static final GuiElement ICON_ButtonHover = new GuiElement(216, 216, 18, 18);
    public static final GuiElement ICON_ButtonPressed = new GuiElement(144, 216, 18, 18);
    protected final ContainerMultiModule<?> container;
    protected GuiTinkerTabs tinkerTabs;
    private final World world;

    public GuiTinkerStation(World world, BlockPos pos, ContainerTinkerStation<?> container) {
        super(container);
        this.world = world;
        this.container = container;
        this.tinkerTabs = new GuiTinkerTabs(this, (Container)container);
        this.addModule(this.tinkerTabs);
        if (container.hasCraftingStation) {
            for (Pair<BlockPos, IBlockState> pair : container.tinkerStationBlocks) {
                IBlockState state = (IBlockState)pair.getRight();
                BlockPos blockPos = (BlockPos)pair.getLeft();
                ItemStack stack = (ItemStack)state.func_177230_c().getDrops((IBlockAccess)world, blockPos, state, 0).get(0);
                this.tinkerTabs.addTab(stack, blockPos);
            }
        }
        for (int i = 0; i < this.tinkerTabs.tabData.size(); ++i) {
            if (!this.tinkerTabs.tabData.get(i).equals((Object)pos)) continue;
            this.tinkerTabs.tabs.selected = i;
        }
    }

    protected void drawIcon(Slot slot, GuiElement element) {
        this.field_146297_k.func_110434_K().func_110577_a(ICONS);
        element.draw(slot.field_75223_e + this.cornerX - 1, slot.field_75221_f + this.cornerY - 1);
    }

    protected void drawIconEmpty(Slot slot, GuiElement element) {
        if (slot.func_75216_d()) {
            return;
        }
        this.drawIcon(slot, element);
    }

    public void onTabSelection(int selection) {
        if (selection < 0 || selection > this.tinkerTabs.tabData.size()) {
            return;
        }
        BlockPos pos = this.tinkerTabs.tabData.get(selection);
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ITinkerStationBlock) {
            TileEntity te = this.world.func_175625_s(pos);
            if (te instanceof IInventoryGui) {
                TinkerNetwork.sendToServer((AbstractPacket)new TinkerStationTabPacket(pos));
            }
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
    }

    public void error(String message) {
    }

    public void warning(String message) {
    }

    public void updateDisplay() {
    }
}

