/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.tileentity.TileFaucet;

public class BlockFaucet
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing input) {
            return input != EnumFacing.DOWN;
        }
    });

    public BlockFaucet() {
        super(Material.field_151576_e);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabSmeltery);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(field_149777_j);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing face;
        if (meta >= EnumFacing.values().length) {
            meta = 1;
        }
        if ((face = EnumFacing.values()[meta]) == EnumFacing.DOWN) {
            face = EnumFacing.UP;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileFaucet) {
            ((TileFaucet)te).activate();
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
    }

    public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileFaucet) {
            ((TileFaucet)te).handleRedstone(worldIn.func_175640_z(pos));
        }
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
        float xMin = 0.25f;
        float xMax = 0.75f;
        float zMin = 0.25f;
        float zMax = 0.75f;
        float yMin = 0.25f;
        float yMax = 0.625f;
        switch (facing) {
            case UP: {
                yMin = 0.625f;
                yMax = 1.0f;
                break;
            }
            case SOUTH: {
                zMin = 0.625f;
                zMax = 1.0f;
                break;
            }
            case NORTH: {
                zMax = 0.375f;
                zMin = 0.0f;
                break;
            }
            case EAST: {
                xMin = 0.625f;
                xMax = 1.0f;
                break;
            }
            case WEST: {
                xMax = 0.375f;
                xMin = 0.0f;
            }
        }
        this.func_149676_a(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        float xMin = 0.25f;
        float xMax = 0.75f;
        float zMin = 0.25f;
        float zMax = 0.75f;
        float yMin = 0.25f;
        float yMax = 0.625f;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case UP: {
                yMin = 0.625f;
                yMax = 1.0f;
                break;
            }
            case SOUTH: {
                zMin = 0.625f;
                zMax = 1.0f;
                break;
            }
            case NORTH: {
                zMax = 0.375f;
                zMin = 0.0f;
                break;
            }
            case EAST: {
                xMin = 0.625f;
                xMax = 1.0f;
                break;
            }
            case WEST: {
                xMax = 0.375f;
                xMin = 0.0f;
            }
        }
        return AxisAlignedBB.func_178781_a((double)((float)pos.func_177958_n() + xMin), (double)((float)pos.func_177956_o() + yMin), (double)((float)pos.func_177952_p() + zMin), (double)((float)pos.func_177958_n() + xMax), (double)((float)pos.func_177956_o() + yMax), (double)((float)pos.func_177952_p() + zMax));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFaucet();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = facing.func_176734_d();
        if (enumfacing == EnumFacing.DOWN) {
            enumfacing = placer.func_174811_aO().func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }
}

