/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.events.TinkerToolEvent;
import slimeknights.tconstruct.tools.network.ToolBreakAnimationPacket;

public final class ToolHelper {
    private ToolHelper() {
    }

    public static boolean hasCategory(ItemStack stack, Category category) {
        if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof TinkersItem)) {
            return false;
        }
        return ((TinkersItem)stack.func_77973_b()).hasCategory(category);
    }

    public static int getDurabilityStat(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "Durability");
    }

    public static int getHarvestLevelStat(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "HarvestLevel");
    }

    public static float getMiningSpeedStat(ItemStack stack) {
        return ToolHelper.getfloatTag(stack, "MiningSpeed");
    }

    public static float getAttackStat(ItemStack stack) {
        return ToolHelper.getfloatTag(stack, "Attack");
    }

    public static float getActualAttack(ItemStack stack) {
        float damage = ToolHelper.getAttackStat(stack);
        if (stack != null && stack.func_77973_b() instanceof ToolCore) {
            damage *= ((ToolCore)stack.func_77973_b()).damagePotential();
        }
        return damage;
    }

    public static float getActualMiningSpeed(ItemStack stack) {
        float speed = ToolHelper.getMiningSpeedStat(stack);
        if (stack != null && stack.func_77973_b() instanceof ToolCore) {
            speed *= ((ToolCore)stack.func_77973_b()).miningSpeedModifier();
        }
        return speed;
    }

    public static int getFreeModifiers(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "FreeModifiers");
    }

    public static List<ITrait> getTraits(ItemStack stack) {
        LinkedList traits = Lists.newLinkedList();
        NBTTagList traitsTagList = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < traitsTagList.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(traitsTagList.func_150307_f(i));
            if (trait == null) continue;
            traits.add(trait);
        }
        return traits;
    }

    public static float calcDigSpeed(ItemStack stack, IBlockState blockState) {
        if (blockState == null) {
            return 0.0f;
        }
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        if (!ToolHelper.canHarvest(stack, blockState)) {
            return 0.0f;
        }
        if (ToolHelper.isBroken(stack)) {
            return 0.3f;
        }
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        float strength = stack.func_77973_b().func_150893_a(stack, blockState.func_177230_c());
        float speed = tag.func_74760_g("MiningSpeed");
        if (stack.func_77973_b() instanceof ToolCore) {
            speed *= ((ToolCore)stack.func_77973_b()).miningSpeedModifier();
        }
        return strength * speed;
    }

    public static boolean isToolEffective(ItemStack stack, IBlockState state) {
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolEffective2(ItemStack stack, IBlockState state) {
        if (ToolHelper.isToolEffective(stack, state)) {
            return true;
        }
        return stack.func_77973_b() instanceof ToolCore && ((ToolCore)stack.func_77973_b()).isEffective(state.func_177230_c());
    }

    public static boolean canHarvest(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block.func_149688_o().func_76229_l()) {
            return true;
        }
        String type = block.getHarvestTool(state);
        int level = block.getHarvestLevel(state);
        return stack.func_77973_b().getHarvestLevel(stack, type) >= level;
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, width, height, depth, -1);
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        if (stack == null || !(stack.func_77973_b() instanceof ToolCore)) {
            return ImmutableList.of();
        }
        IBlockState state = world.func_180495_p(origin);
        Block block = state.func_177230_c();
        if (block.func_149688_o() == Material.field_151579_a) {
            return ImmutableList.of();
        }
        MovingObjectPosition mop = ((ToolCore)stack.func_77973_b()).func_77621_a(world, player, false);
        if (mop == null) {
            return ImmutableList.of();
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(stack, player, width, height, depth, distance);
        width = event.width;
        height = event.height;
        depth = event.depth;
        distance = event.distance;
        BlockPos start = origin;
        switch (mop.field_178784_b) {
            case DOWN: 
            case UP: {
                Vec3i vec = player.func_174811_aO().func_176730_m();
                x = vec.func_177958_n() * height + vec.func_177952_p() * width;
                y = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                z = vec.func_177958_n() * width + vec.func_177952_p() * height;
                start = start.func_177982_a(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() > 0.5) {
                        start = start.func_177982_a(1, 0, 0);
                    } else if (x < 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() < 0.5) {
                        start = start.func_177982_a(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() > 0.5) {
                    start = start.func_177982_a(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() < 0.5)) break;
                start = start.func_177982_a(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                start = start.func_177982_a(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() > 0.5) {
                    start = start.func_177982_a(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.field_72307_f.field_72448_b - (double)mop.func_178782_a().func_177956_o() > 0.5)) break;
                start = start.func_177982_a(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                y = height;
                z = width;
                start = start.func_177982_a(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.field_72307_f.field_72448_b - (double)mop.func_178782_a().func_177956_o() > 0.5) {
                    start = start.func_177982_a(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() > 0.5)) break;
                start = start.func_177982_a(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.func_177958_n(); xp != start.func_177958_n() + x; xp += x / MathHelper.func_76130_a((int)x)) {
            for (int yp = start.func_177956_o(); yp != start.func_177956_o() + y; yp += y / MathHelper.func_76130_a((int)y)) {
                for (int zp = start.func_177952_p(); zp != start.func_177952_p() + z; zp += z / MathHelper.func_76130_a((int)z)) {
                    BlockPos pos;
                    if (xp == origin.func_177958_n() && yp == origin.func_177956_o() && zp == origin.func_177952_p() || distance > 0 && MathHelper.func_76130_a((int)(xp - origin.func_177958_n())) + MathHelper.func_76130_a((int)(yp - origin.func_177956_o())) + MathHelper.func_76130_a((int)(zp - origin.func_177952_p())) > distance || !ToolHelper.isToolEffective2(stack, world.func_180495_p(pos = new BlockPos(xp, yp, zp)))) continue;
                    builder.add((Object)pos);
                }
            }
        }
        return builder.build();
    }

    public static void breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (world.func_175623_d(pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!ToolHelper.isToolEffective2(stack, state)) {
            return;
        }
        IBlockState refState = world.func_180495_p(refPos);
        float refStrength = ForgeHooks.blockStrength((IBlockState)refState, (EntityPlayer)player, (World)world, (BlockPos)refPos);
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(world, pos));
            }
            return;
        }
        stack.func_179548_a(world, block, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, world.func_175625_s(pos));
                block.func_180637_b(world, pos, xp);
            }
            EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
            mpPlayer.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(world, pos));
        } else {
            PlayerControllerMP pcmp = Minecraft.func_71410_x().field_71442_b;
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            if (block.removedByPlayer(world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            stack.func_179548_a(world, block, pos, player);
            if (stack.field_77994_a == 0 && stack == player.func_71045_bC()) {
                player.func_71028_bD();
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    public static boolean shearBlock(ItemStack itemstack, World world, EntityPlayer player, BlockPos pos) {
        IShearable target;
        if (world.field_72995_K) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)world, pos)) {
            int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack);
            List drops = target.onSheared(itemstack, (IBlockAccess)world, pos, fortune);
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                world.func_72838_d((Entity)entityitem);
            }
            itemstack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public static int getCurrentDurability(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    public static void damageTool(ItemStack stack, int amount, EntityLivingBase entity) {
        if (amount == 0 || ToolHelper.isBroken(stack)) {
            return;
        }
        int actualAmount = amount;
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
            if (trait == null) continue;
            actualAmount = amount > 0 ? trait.onToolDamage(stack, amount, actualAmount, entity) : trait.onToolHeal(stack, amount, actualAmount, entity);
        }
        actualAmount = Math.min(actualAmount, ToolHelper.getCurrentDurability(stack));
        stack.func_77964_b(stack.func_77952_i() + actualAmount);
        if (ToolHelper.getCurrentDurability(stack) == 0) {
            ToolHelper.breakTool(stack, entity);
        }
    }

    public static void healTool(ItemStack stack, int amount, EntityLivingBase entity) {
        ToolHelper.damageTool(stack, -amount, entity);
    }

    public static boolean isBroken(ItemStack stack) {
        return TagUtil.getToolTag(stack).func_74767_n("Broken");
    }

    public static void breakTool(ItemStack stack, EntityLivingBase entity) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        tag.func_74757_a("Broken", true);
        TagUtil.setToolTag(stack, tag);
        if (entity instanceof EntityPlayerMP) {
            TinkerNetwork.sendTo((AbstractPacket)new ToolBreakAnimationPacket(stack), (EntityPlayerMP)entity);
        }
    }

    public static void repairTool(ItemStack stack, int amount) {
        ToolHelper.repairTool(stack, amount, null);
    }

    public static void repairTool(ItemStack stack, int amount, EntityLivingBase entity) {
        if (ToolHelper.isBroken(stack)) {
            stack.func_77964_b(stack.func_77958_k());
            NBTTagCompound tag = TagUtil.getToolTag(stack);
            tag.func_74757_a("Broken", false);
            TagUtil.setToolTag(stack, tag);
        }
        TinkerToolEvent.OnRepair.fireEvent(stack, amount);
        ToolHelper.healTool(stack, amount, entity);
    }

    public static boolean attackEntity(ItemStack stack, ToolCore tool, EntityPlayer player, Entity targetEntity) {
        if (targetEntity == null || !targetEntity.func_70075_an() || targetEntity.func_85031_j((Entity)player) || !stack.func_77942_o()) {
            return false;
        }
        if (!(targetEntity instanceof EntityLivingBase)) {
            return false;
        }
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        EntityLivingBase target = (EntityLivingBase)targetEntity;
        LinkedList traits = Lists.newLinkedList();
        NBTTagList traitsTagList = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < traitsTagList.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(traitsTagList.func_150307_f(i));
            if (trait == null) continue;
            traits.add(trait);
        }
        float baseDamage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float baseKnockback = player.func_70051_ag() ? 1.0f : 0.0f;
        baseDamage += ToolHelper.getAttackStat(stack);
        baseDamage *= tool.damagePotential();
        boolean isCritical = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && targetEntity instanceof EntityLivingBase;
        for (Object trait : traits) {
            if (!trait.isCriticalHit(stack, (EntityLivingBase)player, target)) continue;
            isCritical = true;
        }
        float damage = baseDamage;
        for (Object trait : traits) {
            damage = trait.damage(stack, (EntityLivingBase)player, target, baseDamage, damage, isCritical);
        }
        if (isCritical) {
            damage *= 1.5f;
        }
        damage = ToolHelper.calcCutoffDamage(damage, tool.damageCutoff());
        float knockback = baseKnockback;
        for (ITrait trait : traits) {
            knockback = trait.knockBack(stack, (EntityLivingBase)player, target, damage, baseKnockback, knockback, isCritical);
        }
        float oldHP = target.func_110143_aJ();
        double oldVelX = target.field_70159_w;
        double oldVelY = target.field_70181_x;
        double oldVelZ = target.field_70179_y;
        int hurtResistantTime = target.field_70172_ad;
        for (ITrait trait : traits) {
            trait.onHit(stack, (EntityLivingBase)player, target, damage, isCritical);
            target.field_70172_ad = hurtResistantTime;
        }
        boolean hit = tool.dealDamage(stack, player, target, damage);
        if (hit) {
            float damageDealt = oldHP - target.func_110143_aJ();
            oldVelX = target.field_70159_w = oldVelX + (target.field_70159_w - oldVelX) * (double)tool.knockback();
            oldVelY = target.field_70181_x = oldVelY + (target.field_70181_x - oldVelY) * (double)tool.knockback() / 3.0;
            oldVelZ = target.field_70179_y = oldVelZ + (target.field_70179_y - oldVelZ) * (double)tool.knockback();
            if (knockback > 0.0f) {
                double velX = -MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f;
                double velZ = MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f;
                targetEntity.func_70024_g(velX, 0.1, velZ);
                player.field_70159_w *= (double)0.6f;
                player.field_70179_y *= (double)0.6f;
                player.func_70031_b(false);
            }
            if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(targetEntity));
                targetEntity.field_70133_I = false;
                targetEntity.field_70159_w = oldVelX;
                targetEntity.field_70181_x = oldVelY;
                targetEntity.field_70179_y = oldVelZ;
            }
            if (isCritical) {
                player.func_71009_b((Entity)target);
            }
            if (damage > baseDamage) {
                player.func_71047_c(targetEntity);
            }
            if (damage >= 18.0f) {
                player.func_71029_a((StatBase)AchievementList.field_75999_E);
            }
            player.func_130011_c((Entity)target);
            for (ITrait trait : traits) {
                trait.afterHit(stack, (EntityLivingBase)player, target, damageDealt, isCritical, hit);
            }
            stack.func_77961_a(target, player);
            if (!player.field_71075_bZ.field_75098_d) {
                tool.reduceDurabilityOnHit(stack, player, damage);
            }
            player.func_71064_a(StatList.field_75951_w, Math.round(damage * 10.0f));
            player.func_71020_j(0.3f);
        }
        return true;
    }

    public static float calcCutoffDamage(float damage, float cutoff) {
        float p = 1.0f;
        float d = damage;
        damage = 0.0f;
        while (d > cutoff) {
            damage += p * cutoff;
            if (p > 0.001f) {
                p *= 0.9f;
            } else {
                return damage += p * cutoff * (d / cutoff - 1.0f);
            }
            d -= cutoff;
        }
        return damage += p * d;
    }

    public static float getActualDamage(ItemStack stack, EntityPlayer player) {
        float damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        damage += ToolHelper.getActualAttack(stack);
        if (stack.func_77973_b() instanceof ToolCore) {
            damage = ToolHelper.calcCutoffDamage(damage, ((ToolCore)stack.func_77973_b()).damageCutoff());
        }
        return damage;
    }

    public static void swingItem(int speed, EntityLivingBase entity) {
        if (!entity.field_82175_bq || entity.field_110158_av >= 3 || entity.field_110158_av < 0) {
            entity.field_110158_av = Math.min(4, -1 + speed);
            entity.field_82175_bq = true;
            if (entity.field_70170_p instanceof WorldServer) {
                ((WorldServer)entity.field_70170_p).func_73039_n().func_151247_a((Entity)entity, (Packet)new S0BPacketAnimation((Entity)entity, 0));
            }
        }
    }

    public static boolean useSecondaryItem(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        int slot = ToolHelper.getSecondaryItemSlot(player);
        if (slot == player.field_71071_by.field_70461_c) {
            return false;
        }
        ItemStack secondaryItem = player.field_71071_by.func_70301_a(slot);
        if (secondaryItem == null) {
            return false;
        }
        int oldSlot = player.field_71071_by.field_70461_c;
        player.field_71071_by.field_70461_c = slot;
        boolean ret = secondaryItem.func_179546_a(player, world, pos, side, hitX, hitY, hitZ);
        if (secondaryItem.field_77994_a == 0) {
            player.field_71071_by.func_70299_a(slot, null);
        }
        player.field_71071_by.field_70461_c = oldSlot;
        return ret;
    }

    public static int getSecondaryItemSlot(EntityPlayer player) {
        ItemStack secondaryItem;
        int slot = player.field_71071_by.field_70461_c;
        int max = InventoryPlayer.func_70451_h() - 1;
        if (slot < max) {
            ++slot;
        }
        while (slot < max && ((secondaryItem = player.field_71071_by.func_70301_a(slot)) == null || secondaryItem.func_77973_b() instanceof ToolCore && ((ToolCore)secondaryItem.func_77973_b()).canUseSecondaryItem())) {
            ++slot;
        }
        secondaryItem = player.field_71071_by.func_70301_a(slot);
        if (secondaryItem != null && secondaryItem.func_77973_b() instanceof ToolCore && ((ToolCore)secondaryItem.func_77973_b()).canUseSecondaryItem()) {
            return player.field_71071_by.field_70461_c;
        }
        return slot;
    }

    static int getIntTag(ItemStack stack, String key) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        return tag.func_74762_e(key);
    }

    static float getfloatTag(ItemStack stack, String key) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        return tag.func_74760_g(key);
    }
}

