/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.debug.CompareVanilla;
import slimeknights.tconstruct.debug.DamageTool;
import slimeknights.tconstruct.debug.DumpMaterialTest;
import slimeknights.tconstruct.debug.FindBestTool;
import slimeknights.tconstruct.debug.GetToolGrowth;
import slimeknights.tconstruct.debug.LocalizationCheckCommand;
import slimeknights.tconstruct.debug.ReloadResources;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;

@Pulse(id="TinkerDebug", description="Debug utilities", defaultEnable=false)
public class TinkerDebug {
    public static final String PulseId = "TinkerDebug";
    static final Logger log = Util.getLogger("TinkerDebug");

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new ReloadResources());
        }
    }

    @Subscribe
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new DamageTool());
        if (event.getSide().isClient()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new LocalizationCheckCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new DumpMaterialTest());
            ClientCommandHandler.instance.func_71560_a((ICommand)new FindBestTool());
            ClientCommandHandler.instance.func_71560_a((ICommand)new GetToolGrowth());
            ClientCommandHandler.instance.func_71560_a((ICommand)new CompareVanilla());
        }
        TinkerDebug.sanityCheck();
    }

    public static void sanityCheck() {
        int i;
        for (IModifier modifier : TinkerRegistry.getAllModifiers()) {
            try {
                modifier.matches(new ItemStack[]{new ItemStack(Items.field_151055_y)});
                modifier.matches(new ItemStack[1]);
            }
            catch (Exception e) {
                log.error("Caught exception in modifier " + modifier.getIdentifier());
                log.error((Object)e);
            }
        }
        for (ResourceLocation identifier : Block.field_149771_c.func_148742_b()) {
            if (!identifier.func_110624_b().equals(Util.RESOURCE)) continue;
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)identifier);
            for (i = 0; i < 16; ++i) {
                block.func_176201_c(block.func_176203_a(i));
            }
        }
        for (ResourceLocation identifier : Item.field_150901_e.func_148742_b()) {
            if (!identifier.func_110624_b().equals(Util.RESOURCE)) continue;
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)identifier);
            for (i = 0; i < Short.MAX_VALUE; ++i) {
                item.func_77647_b(i);
            }
        }
    }
}

