/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.config;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.config.ConfigSyncPacket;

public class ConfigSync {
    @SideOnly(value=Side.CLIENT)
    private static boolean needsRestart;

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player == null || !(event.player instanceof EntityPlayerMP) || FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        ConfigSyncPacket packet = new ConfigSyncPacket();
        packet.categories.add(Config.Modules);
        packet.categories.add(Config.Gameplay);
        TinkerNetwork.sendTo(packet, (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void playerJoinedWorld(EntityJoinWorldEvent event) {
        if (event.entity == Minecraft.func_71410_x().field_71439_g) {
            if (needsRestart) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("[TConstruct] " + StatCollector.func_74838_a((String)"config.synced.restart")));
            } else {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("[TConstruct] " + StatCollector.func_74838_a((String)"config.synced.ok")));
            }
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public static void syncConfig(List<ConfigCategory> categories) {
        needsRestart = false;
        boolean changed = false;
        Config.log.info("Syncing Config with Server");
        for (ConfigCategory serverCategory : categories) {
            ConfigCategory category = Config.pulseConfig.getCategory();
            if (!serverCategory.getName().equals(category.getName())) {
                category = Config.configFile.getCategory(serverCategory.getName());
            }
            for (Map.Entry entry : serverCategory.entrySet()) {
                String name = (String)entry.getKey();
                Property serverProp = (Property)entry.getValue();
                Property prop = category.get(name);
                if (prop == null) {
                    category.put(name, serverProp);
                    continue;
                }
                if (prop.getString().equals(serverProp.getString())) continue;
                prop.setValue(serverProp.getString());
                needsRestart |= prop.requiresMcRestart();
                changed = true;
                Config.log.debug("Syncing %s - %s: %s", new Object[]{category.getName(), prop.getName(), prop.getString()});
            }
        }
        if (Config.configFile.hasChanged()) {
            Config.configFile.save();
        }
        Config.pulseConfig.flush();
        if (changed) {
            MinecraftForge.EVENT_BUS.register((Object)new ConfigSync());
        }
    }
}

