package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;

import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.potion.TinkerPotion;
import slimeknights.tconstruct.library.traits.AbstractTrait;

public class TraitSharp extends AbstractTrait {

  public static TinkerPotion DOT = new DoT();

  public TraitSharp() {
    super("sharp", 0xffffff);
  }

  @Override
  public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
    if(wasHit && target.func_70089_S()) {
      target.func_130011_c(player);
      DOT.apply(target, 121);
    }
  }

  protected static void dealDamage(EntityLivingBase target, int level) {
    EntityLivingBase lastAttacker = target.func_110144_aD();
    DamageSource source;
    if(lastAttacker != null) {
      source = new EntityDamageSource("bleed", lastAttacker);
    }
    else {
      source = new DamageSource("bleed");
    }

    int hurtResistantTime = target.field_70172_ad;
    attackEntitySecondary(source, (level+1f)/3f, target, true, true);
    target.field_70737_aN = hurtResistantTime;
  }


  public static class DoT extends TinkerPotion {

    public DoT() {
      super(Util.getResource("dot"), true, true);
    }

    @Override
    public boolean func_76397_a(int tick, int level) {
      // every half second
      return tick > 0 && tick % 15 == 0;
    }

    @Override
    public void func_76394_a(EntityLivingBase target, int level) {
      dealDamage(target, level);
    }
  }

}
