package slimeknights.tconstruct.tools.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.inventory.IContainerCraftingCustom;
import slimeknights.mantle.inventory.SlotCraftingCustom;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.inventory.InventoryCraftingPersistent;
import slimeknights.tconstruct.tools.network.StencilTableSelectionPacket;
import slimeknights.tconstruct.tools.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.tileentity.TileStencilTable;

public class ContainerStencilTable
    extends ContainerTinkerStation<TileStencilTable>
    implements IContainerCraftingCustom {

  public InventoryCraftingPersistent craftMatrix;
  public IInventory craftResult;

  private ItemStack output;

  private final Container patternChestSideInventory;

  public ContainerStencilTable(InventoryPlayer playerInventory, TileStencilTable tile) {
    super(tile);

    this.craftMatrix = new InventoryCraftingPersistent(this, tile, 1, 1);
    this.craftResult = new InventoryCraftResult();

    this.func_75146_a(new SlotStencil(this.craftMatrix, 0, 48, 35));
    this.func_75146_a(new SlotCraftingCustom(this, playerInventory.field_70458_d, craftMatrix, craftResult, 1, 106, 35));

    TilePatternChest chest = detectTE(TilePatternChest.class);
    // TE present?
    if(chest != null) {
      patternChestSideInventory = new ContainerPatternChest.DynamicChestInventory(chest, chest, 6 + 176, 8, 6);
      addSubContainer(patternChestSideInventory, true);
    }
    else {
      patternChestSideInventory = null;
    }

    this.addPlayerInventory(playerInventory, 8, 84);
    func_75130_a(null);
  }

  @Override
  protected void syncWithOtherContainer(BaseContainer<TileStencilTable> otherContainer, EntityPlayerMP player) {
    syncWithOtherContainer((ContainerStencilTable) otherContainer, player);
  }

  protected void syncWithOtherContainer(ContainerStencilTable otherContainer, EntityPlayerMP player) {
    this.setOutput(otherContainer.output);
    if(output != null) {
      TinkerNetwork.sendTo(new StencilTableSelectionPacket(output), player);
    }
  }

  public void setOutput(ItemStack stack) {
    if(stack == null) {
      return;
    }
    // ensure that the output is valid
    for(ItemStack candidate : TinkerRegistry.getStencilTableCrafting()) {
      // NBT sensitive
      if(ItemStack.func_77989_b(stack, candidate)) {
        // yay
        output = stack;
        updateResult();
        return;
      }
    }
  }

  @Override
  public void func_75130_a(IInventory inventoryIn) {
    updateResult();
  }

  // Sets the result in the output slot depending on if there's a pattern in the input and on which pattern was selected
  public void updateResult() {
    // no pattern :(
    if(craftMatrix.func_70301_a(0) == null || output == null) {
      craftResult.func_70299_a(0, null);
    }
    else {
      // set pattern from selection (or null if no selection)
      craftResult.func_70299_a(0, output.func_77946_l());
    }
  }

  @Override
  public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
    // we always want to shiftclick the output into a pattern chest if present
    // note that we leave out a few checks/callbacks because we rely on how the stenciltable works
    if(index != 1) {
      return super.func_82846_b(playerIn, index);
    }

    Slot slot = (Slot) this.field_75151_b.get(index);
    if(slot == null || !slot.func_75216_d()) {
      return null;
    }

    ItemStack itemstack = slot.func_75211_c().func_77946_l();
    ItemStack ret = slot.func_75211_c().func_77946_l();

    if(patternChestSideInventory != null) {
      if(moveToContainer(itemstack, patternChestSideInventory)) {
        return null;
      }

      return notifySlotAfterTransfer(playerIn, itemstack, ret, slot);
    }

    return super.func_82846_b(playerIn, index);
  }

  @Override
  public void onCrafting(EntityPlayer player, ItemStack output, IInventory craftMatrix) {
    ItemStack itemstack1 = craftMatrix.func_70301_a(0);

    // Assumption: Only 1 input, will always be decreased by only 1
    if(itemstack1 != null) {
      craftMatrix.func_70298_a(0, 1);
    }

    updateResult();
  }

  @Override
  public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
    // prevents that doubleclicking on a stencil pulls them out of the crafting slot
    return p_94530_2_.field_75224_c != this.craftResult && super.func_94530_a(p_94530_1_, p_94530_2_);
  }
}
