package slimeknights.tconstruct.tools.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

import slimeknights.mantle.client.gui.GuiElement;

public class GuiButtonItem<T> extends GuiButton {
  // Positions from generic.png
  protected static final GuiElement GUI_Button_pressed = new GuiElement(144, 216, 18, 18, 256, 256);
  protected static final GuiElement GUI_Button_normal = new GuiElement(144 + 18 * 2, 216, 18, 18, 256, 256);
  protected static final GuiElement GUI_Button_hover = new GuiElement(144 + 18 * 4, 216, 18, 18, 256, 256);

  private final ItemStack icon;
  public final T data;
  public boolean pressed;

  private GuiElement guiPressed = GUI_Button_pressed;
  private GuiElement guiNormal = GUI_Button_normal;
  private GuiElement guiHover = GUI_Button_hover;
  private ResourceLocation locBackground = GuiTinkerStation.ICONS;

  public GuiButtonItem(int buttonId, int x, int y, String displayName, T data) {
    super(buttonId, x, y, 18, 18, displayName);

    this.icon = null;
    this.data = data;
  }

  public GuiButtonItem(int buttonId, int x, int y, ItemStack icon, T data) {
    super(buttonId, x, y, 18, 18, icon.func_82833_r());

    this.icon = icon;
    this.data = data;
  }

  public GuiButtonItem<T> setGraphics(GuiElement normal, GuiElement hover, GuiElement pressed, ResourceLocation background) {
    guiPressed = pressed;
    guiNormal = normal;
    guiHover = hover;
    locBackground = background;

    return this;
  }

  @Override
  public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
    GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
    mc.func_110434_K().func_110577_a(locBackground);

    if(this.field_146125_m) {
      this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i &&
                     mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;

      if(pressed) {
        guiPressed.draw(field_146128_h, field_146129_i);
      }
      else if(field_146123_n) {
        guiHover.draw(field_146128_h, field_146129_i);
      }
      else {
        guiNormal.draw(field_146128_h, field_146129_i);
      }

      drawIcon(mc);
    }
  }

  protected void drawIcon(Minecraft mc) {
    mc.func_175599_af().func_175042_a(icon, field_146128_h+1, field_146129_i+1);
  }
}
