package slimeknights.tconstruct.world.worldgen;

import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

import java.util.Random;

import slimeknights.tconstruct.world.TinkerWorld;

public class SlimeTreeGenerator implements IWorldGenerator {

  public final int minTreeHeight;
  public final int treeHeightRange;
  public final IBlockState log;
  public final IBlockState leaves;
  public final IBlockState vine;
  public final boolean seekHeight;

  public SlimeTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, IBlockState vine, boolean seekHeight) {
    this.minTreeHeight = treeHeight;
    this.treeHeightRange = treeRange;
    this.log = log;
    this.leaves = leaves;
    this.vine = vine;
    this.seekHeight = seekHeight;
  }

  public SlimeTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, IBlockState vine)
  {
    this(treeHeight, treeRange, log, leaves, vine, true);
  }


  @Override
  public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {

  }

  public void generateTree(Random random, World world, BlockPos pos)
  {
    int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
    boolean flag = true;
    if (seekHeight)
    {
      pos = findGround(world, pos);
      if (pos.func_177956_o() < 0)
        return;
    }

    int yPos = pos.func_177956_o();

    if (yPos >= 1 && yPos + height + 1 <= 256)
    {
      Block soil = world.func_180495_p(pos.func_177977_b()).func_177230_c();
      boolean isSoil = (soil != null && soil.canSustainPlant(world, pos.func_177977_b(), EnumFacing.UP, TinkerWorld.slimeSapling));

      if (isSoil)
      {
        soil.onPlantGrow(world, pos.func_177977_b(), pos);
        placeCanopy(world, random, pos, height);
        placeTrunk(world, pos, height);
      }
    }
  }

  BlockPos findGround (World world, BlockPos pos)
  {
    do
    {
      Block heightID = world.func_180495_p(pos).func_177230_c();
      if ((heightID == TinkerWorld.slimeDirt || heightID == TinkerWorld.slimeGrass) && !world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149662_c())
      {
        return pos.func_177984_a();
      }
      pos = pos.func_177977_b();
    } while (pos.func_177956_o() > 0);

    return pos;
  }

  void placeCanopy (World world, Random random, BlockPos pos, int height)
  {
    pos = pos.func_177981_b(height);
    for (int i = 0; i < 4; i++)
    {
      placeDiamondLayer(world, pos.func_177979_c(i), i + 1);
    }

    IBlockState air = Blocks.field_150350_a.func_176223_P();

    pos = pos.func_177977_b();
    this.setBlockAndMetadata(world, pos.func_177982_a(+4, 0,  0), air);
    this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0,  0), air);
    this.setBlockAndMetadata(world, pos.func_177982_a( 0, 0, +4), air);
    this.setBlockAndMetadata(world, pos.func_177982_a( 0, 0, -4), air);
    this.setBlockAndMetadata(world, pos.func_177982_a(+1, 0, +1), air);
    this.setBlockAndMetadata(world, pos.func_177982_a(+1, 0, -1), air);
    this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, +1), air);
    this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), air);

    //Drippers
    pos = pos.func_177977_b();
    this.setBlockAndMetadata(world, pos.func_177982_a(+3, 0,  0), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0,  0), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a( 0, 0, -3), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a( 0, 0, +3), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(+2, 0, +2), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(+2, 0, -2), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, +2), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), leaves);

    pos = pos.func_177977_b();
    this.setBlockAndMetadata(world, pos.func_177982_a(+3, 0,  0), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0,  0), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a( 0, 0, -3), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a( 0, 0, +3), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(+2, 0, +2), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(+2, 0, -2), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, +2), leaves);
    this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), leaves);

    // vines, woo
    if(vine != null) {
      pos = pos.func_177977_b();

      this.setBlockAndMetadata(world, pos.func_177982_a(+3, 0,  0), getRandomizedVine(random));
      this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0,  0), getRandomizedVine(random));
      this.setBlockAndMetadata(world, pos.func_177982_a( 0, 0, -3), getRandomizedVine(random));
      this.setBlockAndMetadata(world, pos.func_177982_a( 0, 0, +3), getRandomizedVine(random));
      this.setBlockAndMetadata(world, pos.func_177982_a(+2, 0, +2), getRandomizedVine(random));
      this.setBlockAndMetadata(world, pos.func_177982_a(+2, 0, -2), getRandomizedVine(random));
      this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, +2), getRandomizedVine(random));
      this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), getRandomizedVine(random));
    }
  }

  protected IBlockState getRandomizedVine(Random random) {
    IBlockState state = vine;
    PropertyBool[] sides = new PropertyBool[] {BlockVine.field_176273_b, BlockVine.field_176278_M, BlockVine.field_176279_N, BlockVine.field_176280_O};
    for(int i = random.nextInt(3) + 1; i > 0; i--) {
      state = state.func_177226_a(sides[random.nextInt(sides.length)], true);
    }

    return state;
  }

  protected void placeDiamondLayer (World world, BlockPos pos, int range)
  {
    for (int x = -range; x <= range; x++)
    {
      for (int z = -range; z <= range; z++)
      {
        if (Math.abs(x) + Math.abs(z) <= range)
        {
          this.setBlockAndMetadata(world, pos.func_177982_a(x,0,z), leaves);
        }
      }
    }
  }

  protected void placeTrunk (World world, BlockPos pos, int height)
  {
    while(height >= 0) {
      Block block = world.func_180495_p(pos).func_177230_c();
      if (block.isAir(world, pos) || block.func_176200_f(world, pos) || block.isLeaves(world, pos))
      {
        this.setBlockAndMetadata(world, pos, log);
      }

      pos = pos.func_177984_a();
      height--;
    }
  }

  protected void setBlockAndMetadata (World world, BlockPos pos, IBlockState state)
  {
    Block block = world.func_180495_p(pos).func_177230_c();
    if (block.isAir(world, pos) || block.func_176196_c(world, pos) || world.func_180495_p(pos) == leaves)
    {
      world.func_180501_a(pos, state, 2);
    }
  }
}
