package slimeknights.tconstruct.world.block;

import com.google.common.collect.Lists;

import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import sun.reflect.generics.reflectiveObjects.NotImplementedException;

import java.util.List;
import java.util.Random;

import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass.FoliageType;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockSlimeLeaves extends BlockLeaves {

  public BlockSlimeLeaves() {
    this.func_149647_a(TinkerRegistry.tabWorld);
    this.func_149711_c(0.3f);

    this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(field_176236_b, false).func_177226_a(field_176237_a, true));
  }

  @Override
  public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    super.func_180650_b(worldIn, pos, state, rand);
  }

  @SideOnly(Side.CLIENT)
  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    for(FoliageType type : FoliageType.values()) {
      list.add(new ItemStack(this, 1, func_176201_c(this.func_176223_P().func_177226_a(BlockSlimeGrass.FOLIAGE, type))));
    }
  }

  @Override
  public boolean func_149662_c() {
    return Blocks.field_150362_t.func_149662_c();
  }

  @SideOnly(Side.CLIENT)
  @Override
  public EnumWorldBlockLayer func_180664_k() {
    return Blocks.field_150362_t.func_180664_k();
  }

  @Override
  protected int func_176232_d(IBlockState state) {
    return 25;
  }

  // sapling item
  @Override
  public Item func_180660_a(IBlockState state, Random rand, int fortune) {
    return Item.func_150898_a(TinkerWorld.slimeSapling);
  }

  @Override
  protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
    if(worldIn.field_73012_v.nextInt(chance) == 0) {
      ItemStack stack = null;
      if(state.func_177229_b(BlockSlimeGrass.FOLIAGE) == FoliageType.PURPLE) {
        stack = TinkerCommons.matSlimeBallPurple.func_77946_l();
      }
      else if(state.func_177229_b(BlockSlimeGrass.FOLIAGE) == FoliageType.BLUE) {
        if(worldIn.field_73012_v.nextInt(3) == 0) {
          stack = TinkerCommons.matSlimeBallBlue.func_77946_l();
        }
        else {
          stack = new ItemStack(Items.field_151123_aH);
        }
      }

      if(stack != null) {
        func_180635_a(worldIn, pos, stack);
      }
    }
  }

  // sapling meta
  @Override
  public int func_180651_a(IBlockState state) {
    return (state.func_177229_b(BlockSlimeGrass.FOLIAGE)).ordinal() & 3; // only first 2 bits
  }

  // item dropped on silktouching
  protected ItemStack func_180643_i(IBlockState state)
  {
    return new ItemStack(Item.func_150898_a(this), 1, (state.func_177229_b(BlockSlimeGrass.FOLIAGE)).ordinal() & 3);
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, BlockSlimeGrass.FOLIAGE, field_176236_b, field_176237_a);
  }

  /**
   * Convert the given metadata into a BlockState for this Block
   */
  public IBlockState func_176203_a(int meta)
  {
    int type = meta % 4;
    if(type < 0 || type >= FoliageType.values().length) {
      type = 0;
    }
    FoliageType grass = FoliageType.values()[type];
    return this.func_176223_P()
               .func_177226_a(BlockSlimeGrass.FOLIAGE, grass)
               .func_177226_a(field_176237_a, (meta & 4) == 0)
               .func_177226_a(field_176236_b, (meta & 8) > 0);
  }

  /**
   * Convert the BlockState into the correct metadata value
   */
  public int func_176201_c(IBlockState state)
  {

    int meta = (state.func_177229_b(BlockSlimeGrass.FOLIAGE)).ordinal() & 3; // only first 2 bits

    if (!state.func_177229_b(field_176237_a))
    {
      meta |= 4;
    }

    if (state.func_177229_b(field_176236_b))
    {
      meta |= 8;
    }

    return meta;
  }

  @Override
  @SideOnly(Side.CLIENT)
  public int func_149635_D ()
  {
    return 0xffffff;
  }

  // Used for the item
  @SideOnly(Side.CLIENT)
  @Override
  public int func_180644_h(IBlockState state) {
    FoliageType foliageType = state.func_177229_b(BlockSlimeGrass.FOLIAGE);
    return SlimeColorizer.getColorStatic(foliageType);
  }

  // Used for the block in world
  @SideOnly(Side.CLIENT)
  @Override
  public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
    IBlockState state = worldIn.func_180495_p(pos);
    if(state.func_177230_c() != this) return func_149635_D();

    FoliageType foliageType = state.func_177229_b(BlockSlimeGrass.FOLIAGE);
    return SlimeColorizer.getColorForPos(pos.func_177963_a(SlimeColorizer.loop/2, 0, SlimeColorizer.loop/2), foliageType);
  }

  @Override
  public BlockPlanks.EnumType func_176233_b(int meta) {
    throw new NotImplementedException(); // unused by our code.
  }

  @Override
  public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
    IBlockState state = world.func_180495_p(pos);
    return Lists.newArrayList(func_180643_i(state));
  }

  @Override
  public boolean isLeaves(IBlockAccess world, BlockPos pos) {
    return true;
  }
}
