package slimeknights.tconstruct.world;

import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.entity.RenderSlime;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.client.renderer.RenderTinkerSlime;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockSlimeSapling;
import slimeknights.tconstruct.world.block.BlockTallSlimeGrass;
import slimeknights.tconstruct.world.client.CustomStateMap;
import slimeknights.tconstruct.world.client.SlimeColorizer;
import slimeknights.tconstruct.world.entity.EntityBlueSlime;

public class WorldClientProxy extends ClientProxy {
  public static SlimeColorizer slimeColorizer = new SlimeColorizer();

  @Override
  public void preInit() {
    ((IReloadableResourceManager) Minecraft.func_71410_x().func_110442_L()).func_110542_a(slimeColorizer);
    // Entities
    RenderingRegistry.registerEntityRenderingHandler(EntityBlueSlime.class, RenderTinkerSlime.FACTORY_BlueSlime);

    super.preInit();
  }

  @Override
  protected void registerModels() {
    // blocks
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeGrass, (new StateMap.Builder()).func_178442_a(BlockSlimeGrass.FOLIAGE).func_178441_a());
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeLeaves, (new StateMap.Builder())
        .func_178442_a(BlockSlimeGrass.FOLIAGE, BlockLeaves.field_176236_b, BlockLeaves.field_176237_a).func_178441_a());
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeGrassTall, (new StateMap.Builder()).func_178442_a(BlockSlimeGrass.FOLIAGE).func_178441_a());
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeSapling, (new StateMap.Builder()).func_178442_a(BlockSlimeSapling.field_176479_b, BlockSapling.field_176480_a).func_178441_a());

    //ModelLoader.setCustomStateMapper(TinkerWorld.slimeVine, (new StateMap.Builder()).ignore(BlockSlimeVine.FOLIAGE).build());

    IStateMapper vineMap = new CustomStateMap("slime_vine");
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeVineBlue1, vineMap);
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeVinePurple1, vineMap);
    vineMap = new CustomStateMap("slime_vine_mid");
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeVineBlue2, vineMap);
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeVinePurple2, vineMap);
    vineMap = new CustomStateMap("slime_vine_end");
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeVineBlue3, vineMap);
    ModelLoader.setCustomStateMapper(TinkerWorld.slimeVinePurple3, vineMap);

    // items
    IBlockState state = TinkerWorld.slimeSapling.func_176223_P();
    Item sapling = Item.func_150898_a(TinkerWorld.slimeSapling);
    ItemStack stack = new ItemStack(sapling, 1, TinkerWorld.slimeSapling.func_176201_c(state.func_177226_a(BlockSlimeSapling.FOLIAGE, BlockSlimeGrass.FoliageType.BLUE)));
    registerItemModel(stack, "slime_sapling_blue");
    stack = new ItemStack(sapling, 1, TinkerWorld.slimeSapling.func_176201_c(state.func_177226_a(BlockSlimeSapling.FOLIAGE, BlockSlimeGrass.FoliageType.PURPLE)));
    registerItemModel(stack, "slime_sapling_purple");
    stack = new ItemStack(sapling, 1, TinkerWorld.slimeSapling.func_176201_c(state.func_177226_a(BlockSlimeSapling.FOLIAGE, BlockSlimeGrass.FoliageType.ORANGE)));
    registerItemModel(stack, "slime_sapling_orange");

    for(BlockSlimeGrass.FoliageType foliage : BlockSlimeGrass.FoliageType.values()) {
      state = TinkerWorld.slimeGrassTall.func_176223_P();
      state = state.func_177226_a(BlockTallSlimeGrass.FOLIAGE, foliage);
      state = state.func_177226_a(BlockTallSlimeGrass.TYPE, BlockTallSlimeGrass.SlimePlantType.TALL_GRASS);
      stack = new ItemStack(TinkerWorld.slimeGrassTall, 0, TinkerWorld.slimeGrassTall.func_176201_c(state));
      registerItemModel(stack, "slime_tall_grass");

      state = state.func_177226_a(BlockTallSlimeGrass.TYPE, BlockTallSlimeGrass.SlimePlantType.FERN);
      stack = new ItemStack(TinkerWorld.slimeGrassTall, 0, TinkerWorld.slimeGrassTall.func_176201_c(state));
      registerItemModel(stack, "slime_fern");
    }

    registerItemModel(new ItemStack(TinkerWorld.slimeVineBlue1), "slime_vine");
    registerItemModel(new ItemStack(TinkerWorld.slimeVineBlue2), "slime_vine_mid");
    registerItemModel(new ItemStack(TinkerWorld.slimeVineBlue3), "slime_vine_end");
    registerItemModel(new ItemStack(TinkerWorld.slimeVinePurple1), "slime_vine");
    registerItemModel(new ItemStack(TinkerWorld.slimeVinePurple2), "slime_vine_mid");
    registerItemModel(new ItemStack(TinkerWorld.slimeVinePurple3), "slime_vine_end");
  }

  @Override
  public void postInit() {
    super.postInit();

  }
}
