package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;

import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitShocking extends AbstractTrait {
  public TraitShocking() {
    super("shocking", 0xffffff);
  }

  @Override
  public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
    if(player.field_70170_p.field_72995_K) {
      return;
    }
    NBTTagCompound tag = TinkerUtil.getModifierTag(tool, identifier);
    Data data = Data.read(tag);
    if(data.charge >= 100f) {
      if(attackEntitySecondary(new EntityDamageSource("lightningBolt", player), 5f, target, false, true, false)) {
        //player.worldObj.playSoundEffect(target.posX, target.posY, target.posZ, "ambient.weather.thunder", 10000f, 1f);
        //player.worldObj.playSoundEffect(player.posX, player.posY, player.posZ, "ambient.weather.thunder", 10000.0F, 0.9F);
        //player.playSound(Sounds.shocking_discharge, 1f, 0.8f + random.nextFloat()*0.2f);
        if(player instanceof EntityPlayerMP) {
          ((EntityPlayerMP) player).field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, Sounds.shocking_discharge, 2f, 1f);
          //((EntityPlayerMP) player).playerNetServerHandler.sendPacket(new S29PacketSoundEffect(Sounds.shocking_discharge, player.posX, player.posY, player.posZ, 1f, 0.8f + 0.2f*random.nextFloat()));
        }
        data.charge = 0;

        NBTTagList tagList = TagUtil.getModifiersTagList(tool);
        int index = TinkerUtil.getIndexInCompoundList(tagList, identifier);
        data.write(tag);
        tagList.func_150304_a(index, tag);
        TagUtil.setModifiersTagList(tool, tagList);
        TagUtil.setEnchantEffect(tool, false);
      }
    }
  }

  @Override
  public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
    if(!isSelected || world.field_72995_K) {
      return;
    }
    NBTTagList tagList = TagUtil.getModifiersTagList(tool);
    int index = TinkerUtil.getIndexInCompoundList(tagList, identifier);
    NBTTagCompound tag = tagList.func_150305_b(index);

    Data data = Data.read(tag);

    // fully charged
    if(data.charge >= 100) {
      return;
    }

    // how far did we move?
    double dx = entity.field_70165_t - data.x;
    double dy = entity.field_70163_u - data.y;
    double dz = entity.field_70161_v - data.z;

    double dist = Math.sqrt(dx*dx + dy*dy + dz*dz);
    if(dist < 0.1f) {
      return;
    }
    else if(dist > 5f) {
      dist = 5f;
    }
    data.charge += dist*2f;

    // play sound when fully charged
    if(data.charge >= 100f) {
      TagUtil.setEnchantEffect(tool, true);
      // send only to the player that is charged
      if(entity instanceof EntityPlayerMP) {
        ((EntityPlayerMP) entity).field_71135_a.func_147359_a(new S29PacketSoundEffect(Sounds.shocking_charged, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1f, 0.8f + 0.2f*random.nextFloat()));
      }
    }

    data.x = entity.field_70165_t;
    data.y = entity.field_70163_u;
    data.z = entity.field_70161_v;
    data.write(tag);

    tagList.func_150304_a(index, tag);
    TagUtil.setModifiersTagList(tool, tagList);
  }

  public static class Data {
    float charge;
    double x;
    double y;
    double z;

    public static Data read(NBTTagCompound tag) {
      Data data = new Data();
      data.charge = tag.func_74760_g("charge");
      data.x = tag.func_74769_h("x");
      data.y = tag.func_74769_h("y");
      data.z = tag.func_74769_h("z");
      return data;
    }

    public void write(NBTTagCompound tag) {
      tag.func_74776_a("charge", charge);
      tag.func_74780_a("x", x);
      tag.func_74780_a("y", y);
      tag.func_74780_a("z", z);
    }
  }
}
