package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.entity.player.PlayerEvent;

import slimeknights.tconstruct.library.traits.AbstractTrait;

/**
 * Increases mining speed and damage in hot/dry areas, decreases a bit in dry areas
 */
public class TraitAridiculous extends AbstractTrait {

  public TraitAridiculous() {
    super("aridiculous", EnumChatFormatting.DARK_RED);
  }

  @Override
  public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
    // speedup or slowdown depending on biome temperature. hotter areas are much faster
    float coeff = calcAridiculousness(event.entityPlayer.field_70170_p, event.pos) / 10f; // /10 = 10% for a coeff of 1. But can be bigger.
    event.newSpeed += event.originalSpeed * coeff;
  }

  @Override
  public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
    float extraDamage = 2f * calcAridiculousness(player.field_70170_p, player.func_180425_c());
    return extraDamage + super.damage(tool, player, target, damage, newDamage, isCritical);
  }

  protected float calcAridiculousness(World world, BlockPos pos) {
    BiomeGenBase biome = world.func_180494_b(pos);
    float rain = world.func_72896_J() ? biome.func_76727_i() / 2f : 0f;
    return (float) (Math.pow(1.25, 3d * (0.5f + biome.field_76750_F - biome.field_76751_G)) - 1.25d) - rain;
  }
}
