package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.TinkerTools;

// todo: make some kind of class->head registry that can be expanded via IMC for the lookup
public class ModBeheading extends Modifier {

  public ModBeheading() {
    super("beheading");

    addAspects(new ModifierAspect.LevelAspect(this, 10), new ModifierAspect.DataAspect(this, 0x10574b), ModifierAspect.freeModifier);

    MinecraftForge.EVENT_BUS.register(this);
  }

  @Override
  public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
    // nothing to do
  }

  @SubscribeEvent
  public void onLivingDrops(LivingDropsEvent event) {
    if(event.source.func_76346_g() instanceof EntityPlayer) {
      ItemStack item = ((EntityPlayer) event.source.func_76346_g()).func_70694_bm();
      NBTTagCompound tag = TinkerUtil.getModifierTag(item, getIdentifier());
      int level = ModifierNBT.readTag(tag).level;
      // has beheading
      if(level > 0) {
        if(item.func_77973_b() == TinkerTools.cleaver) {
          level += 2;
        }

        ItemStack head = getHeadDrop(event.entityLiving);
        if(head != null && level > random.nextInt(10)) {
          EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, head);
          entityitem.func_174869_p();
          event.drops.add(entityitem);
        }
      }
    }
  }

  private ItemStack getHeadDrop(EntityLivingBase entity) {
    // meta 0,1: skeleton and wither skelly
    if(entity instanceof EntitySkeleton) {
      return new ItemStack(Items.field_151144_bL, 1, ((EntitySkeleton) entity).func_82202_m());
    }
    // meta 2: zombie
    else if(entity instanceof EntityZombie) {
      return new ItemStack(Items.field_151144_bL, 1, 2);
    }
    // meta 4: creeper
    else if(entity instanceof EntityCreeper) {
      return new ItemStack(Items.field_151144_bL, 1, 4);
    }
    // meta 3: player
    else if(entity instanceof EntityPlayer) {
      ItemStack head = new ItemStack(Items.field_151144_bL, 1, 4);
      NBTTagCompound nametag = new NBTTagCompound();
      nametag.func_74778_a("SkullOwner", entity.func_145748_c_().func_150254_d());
      head.func_77982_d(nametag);
      return head;
    }

    // no head
    return null;
  }
}
